/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft Core JS Edition
 * @website https://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version 3.4.31
 * @fileoverview Dynamsoft JavaScript Library for Core
 * More info on Dynamsoft Core JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/core/core-module.html
 */
!function(e,E){"object"==typeof exports&&"undefined"!=typeof module?E(exports):"function"==typeof define&&define.amd?define(["exports"],E):E(((e="undefined"!=typeof globalThis?globalThis:e||self).Dynamsoft=e.Dynamsoft||{},e.Dynamsoft.Core={}))}(this,(function(e){"use strict";const E=e=>e&&"object"==typeof e&&"function"==typeof e.then,_=(async()=>{})().constructor;class t extends _{get status(){return this._s}get isPending(){return"pending"===this._s}get isFulfilled(){return"fulfilled"===this._s}get isRejected(){return"rejected"===this._s}get task(){return this._task}set task(e){let t;this._task=e,E(e)?t=e:"function"==typeof e&&(t=new _(e)),t&&(async()=>{try{const E=await t;e===this._task&&this.resolve(E)}catch(E){e===this._task&&this.reject(E)}})()}get isEmpty(){return null==this._task}constructor(e){let _,t;super(((e,E)=>{_=e,t=E})),this._s="pending",this.resolve=e=>{this.isPending&&(E(e)?this.task=e:(this._s="fulfilled",_(e)))},this.reject=e=>{this.isPending&&(this._s="rejected",t(e))},this.task=e}}function I(e,E,_,t){if("a"===_&&!t)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof E?e!==E||!t:!E.has(e))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===_?t:"a"===_?t.call(e):t?t.value:E.get(e)}function r(e,E,_,t,I){if("m"===t)throw new TypeError("Private method is not writable");if("a"===t&&!I)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof E?e!==E||!I:!E.has(e))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===t?I.call(e,_):I?I.value=_:E.set(e,_),_}var n,o,a;"function"==typeof SuppressedError&&SuppressedError,e.EnumBufferOverflowProtectionMode=void 0,(n=e.EnumBufferOverflowProtectionMode||(e.EnumBufferOverflowProtectionMode={}))[n.BOPM_BLOCK=0]="BOPM_BLOCK",n[n.BOPM_UPDATE=1]="BOPM_UPDATE",e.EnumColourChannelUsageType=void 0,(o=e.EnumColourChannelUsageType||(e.EnumColourChannelUsageType={}))[o.CCUT_AUTO=0]="CCUT_AUTO",o[o.CCUT_FULL_CHANNEL=1]="CCUT_FULL_CHANNEL",o[o.CCUT_Y_CHANNEL_ONLY=2]="CCUT_Y_CHANNEL_ONLY",o[o.CCUT_RGB_R_CHANNEL_ONLY=3]="CCUT_RGB_R_CHANNEL_ONLY",o[o.CCUT_RGB_G_CHANNEL_ONLY=4]="CCUT_RGB_G_CHANNEL_ONLY",o[o.CCUT_RGB_B_CHANNEL_ONLY=5]="CCUT_RGB_B_CHANNEL_ONLY",e.EnumImagePixelFormat=void 0,(a=e.EnumImagePixelFormat||(e.EnumImagePixelFormat={}))[a.IPF_BINARY=0]="IPF_BINARY",a[a.IPF_BINARYINVERTED=1]="IPF_BINARYINVERTED",a[a.IPF_GRAYSCALED=2]="IPF_GRAYSCALED",a[a.IPF_NV21=3]="IPF_NV21",a[a.IPF_RGB_565=4]="IPF_RGB_565",a[a.IPF_RGB_555=5]="IPF_RGB_555",a[a.IPF_RGB_888=6]="IPF_RGB_888",a[a.IPF_ARGB_8888=7]="IPF_ARGB_8888",a[a.IPF_RGB_161616=8]="IPF_RGB_161616",a[a.IPF_ARGB_16161616=9]="IPF_ARGB_16161616",a[a.IPF_ABGR_8888=10]="IPF_ABGR_8888",a[a.IPF_ABGR_16161616=11]="IPF_ABGR_16161616",a[a.IPF_BGR_888=12]="IPF_BGR_888",a[a.IPF_BINARY_8=13]="IPF_BINARY_8",a[a.IPF_NV12=14]="IPF_NV12",a[a.IPF_BINARY_8_INVERTED=15]="IPF_BINARY_8_INVERTED";const s="undefined"==typeof self,i="function"==typeof importScripts,C=(()=>{if(!i){if(!s&&document.currentScript){let e=document.currentScript.src,E=e.indexOf("?");if(-1!=E)e=e.substring(0,E);else{let E=e.indexOf("#");-1!=E&&(e=e.substring(0,E))}return e.substring(0,e.lastIndexOf("/")+1)}return"./"}})(),A=e=>{if(null==e&&(e="./"),s||i);else{let E=document.createElement("a");E.href=e,e=E.href}return e.endsWith("/")||(e+="/"),e},T=e=>Object.prototype.toString.call(e),N=e=>Array.isArray?Array.isArray(e):"[object Array]"===T(e),R=e=>"[object Boolean]"===T(e),L=e=>"number"==typeof e&&!Number.isNaN(e),D=e=>null!==e&&"object"==typeof e&&!Array.isArray(e),O=e=>!!D(e)&&(!!L(e.width)&&(!(e.width<=0)&&(!!L(e.height)&&(!(e.height<=0)&&(!!L(e.stride)&&(!(e.stride<=0)&&("format"in e&&!("tag"in e&&!m(e.tag))))))))),l=e=>!!O(e)&&e.bytes instanceof Uint8Array,m=e=>null===e||!!D(e)&&(!!L(e.imageId)&&"type"in e),c=e=>!!D(e)&&(!!L(e.x)&&!!L(e.y)),u=e=>{const E={},_={std:"dynamsoft-capture-vision-std",dip:"dynamsoft-image-processing",core:"dynamsoft-core",dnn:"dynamsoft-capture-vision-dnn",license:"dynamsoft-license",utility:"dynamsoft-utility",cvr:"dynamsoft-capture-vision-router",dbr:"dynamsoft-barcode-reader",dlr:"dynamsoft-label-recognizer",ddn:"dynamsoft-document-normalizer",dcp:"dynamsoft-code-parser",dcpd:"dynamsoft-code-parser",dlrData:"dynamsoft-label-recognizer-data",dce:"dynamsoft-camera-enhancer",ddv:"dynamsoft-document-viewer"};for(let t in e){if("rootDirectory"===t)continue;let I=t,r=e[I],n=r&&"object"==typeof r&&r.path?r.path:r,o=e.rootDirectory;if(o&&!o.endsWith("/")&&(o+="/"),"object"==typeof r&&r.isInternal)o&&(n=e[I].version?`${o}${_[I]}@${e[I].version}/dist/${"ddv"===I?"engine":""}`:`${o}${_[I]}/dist/${"ddv"===I?"engine":""}`);else{const _=/^@engineRootDirectory(\/?)/;if("string"==typeof n&&(n=n.replace(_,o||"")),"object"==typeof n&&"dwt"===I){const t=e[I].resourcesPath,r=e[I].serviceInstallerLocation;E[I]={resourcesPath:t.replace(_,o||""),serviceInstallerLocation:r.replace(_,o||"")};continue}}E[I]=A(n)}return E},S=e=>{l(e)&&(e=d(e));const E=document.createElement("canvas");E.width=e.width,E.height=e.height;return E.getContext("2d",{willReadFrequently:!0}).putImageData(e,0,0),E},g=async(e,E)=>{l(E)&&(E=d(E));const _=S(E);return new Promise(((E,t)=>{_.toBlob((e=>E(e)),e)}))},d=E=>{let _,t=E.bytes;if(!(t&&t instanceof Uint8Array))throw Error("Parameter type error");if(Number(E.format)===e.EnumImagePixelFormat.IPF_BGR_888){const e=t.length/3;_=new Uint8ClampedArray(4*e);for(let E=0;E<e;++E)_[4*E]=t[3*E],_[4*E+1]=t[3*E+1],_[4*E+2]=t[3*E+2],_[4*E+3]=255}else if(Number(E.format)===e.EnumImagePixelFormat.IPF_RGB_888){const e=t.length/3;_=new Uint8ClampedArray(4*e);for(let E=0;E<e;++E)_[4*E]=t[3*E+2],_[4*E+1]=t[3*E+1],_[4*E+2]=t[3*E],_[4*E+3]=255}else if(Number(E.format)===e.EnumImagePixelFormat.IPF_GRAYSCALED){const e=t.length;_=new Uint8ClampedArray(4*e);for(let E=0;E<e;E++)_[4*E]=_[4*E+1]=_[4*E+2]=t[E],_[4*E+3]=255}else if(Number(E.format)===e.EnumImagePixelFormat.IPF_BINARY_8){const e=t.length,I=E.width,r=E.height,n=E.stride;_=new Uint8ClampedArray(I*r*4);for(let E=0;E<e;E++){let e=t[E],r=E%n,o=Math.floor(E/n);for(let E=0;E<8;E++){let t=r+E,n=4*(o*I+t);if(t>=I)break;_[n]=_[n+1]=_[n+2]=(128&e)/128*255,_[n+3]=255,e<<=1}}}else if(Number(E.format)===e.EnumImagePixelFormat.IPF_ABGR_8888){const e=t.length/4;_=new Uint8ClampedArray(t.length);for(let E=0;E<e;++E)_[4*E]=t[4*E],_[4*E+1]=t[4*E+1],_[4*E+2]=t[4*E+2],_[4*E+3]=t[4*E+3]}else if(Number(E.format)===e.EnumImagePixelFormat.IPF_ARGB_8888){const e=t.length/4;_=new Uint8ClampedArray(t.length);for(let E=0;E<e;++E)_[4*E]=t[4*E+2],_[4*E+1]=t[4*E+1],_[4*E+2]=t[4*E],_[4*E+3]=t[4*E+3]}else if(Number(E.format)===e.EnumImagePixelFormat.IPF_BINARY_8_INVERTED){const e=t.length,I=E.width,r=E.height,n=E.stride;_=new Uint8ClampedArray(I*r*4);for(let E=0;E<e;E++){let e=t[E],r=E%n,o=Math.floor(E/n);for(let E=0;E<8;E++){let t=r+E,n=4*(o*I+t);if(t>=I)break;_[n]=_[n+1]=_[n+2]=128&e?0:255,_[n+3]=255,e<<=1}}}return new ImageData(_,E.width,E.height)};var P,f,F,h,M,G,U,p;class y{get _isFetchingStarted(){return I(this,M,"f")}constructor(){P.add(this),f.set(this,[]),F.set(this,1),h.set(this,e.EnumBufferOverflowProtectionMode.BOPM_BLOCK),M.set(this,!1),G.set(this,void 0),U.set(this,e.EnumColourChannelUsageType.CCUT_AUTO)}setErrorListener(e){}addImageToBuffer(E){var _;if(!l(E))throw new TypeError("Invalid 'image'.");if((null===(_=E.tag)||void 0===_?void 0:_.hasOwnProperty("imageId"))&&"number"==typeof E.tag.imageId&&this.hasImage(E.tag.imageId))throw new Error("Existed imageId.");if(I(this,f,"f").length>=I(this,F,"f"))switch(I(this,h,"f")){case e.EnumBufferOverflowProtectionMode.BOPM_BLOCK:break;case e.EnumBufferOverflowProtectionMode.BOPM_UPDATE:if(I(this,f,"f").push(E),D(I(this,G,"f"))&&L(I(this,G,"f").imageId)&&1==I(this,G,"f").keepInBuffer)for(;I(this,f,"f").length>I(this,F,"f");){const e=I(this,f,"f").findIndex((e=>{var E;return(null===(E=e.tag)||void 0===E?void 0:E.imageId)!==I(this,G,"f").imageId}));I(this,f,"f").splice(e,1)}else I(this,f,"f").splice(0,I(this,f,"f").length-I(this,F,"f"))}else I(this,f,"f").push(E)}getImage(){if(0===I(this,f,"f").length)return null;let E;if(I(this,G,"f")&&L(I(this,G,"f").imageId)){const e=I(this,P,"m",p).call(this,I(this,G,"f").imageId);if(e<0)throw new Error(`Image with id ${I(this,G,"f").imageId} doesn't exist.`);E=I(this,f,"f").slice(e,e+1)[0]}else E=I(this,f,"f").pop();if([e.EnumImagePixelFormat.IPF_RGB_565,e.EnumImagePixelFormat.IPF_RGB_555,e.EnumImagePixelFormat.IPF_RGB_888,e.EnumImagePixelFormat.IPF_ARGB_8888,e.EnumImagePixelFormat.IPF_RGB_161616,e.EnumImagePixelFormat.IPF_ARGB_16161616,e.EnumImagePixelFormat.IPF_ABGR_8888,e.EnumImagePixelFormat.IPF_ABGR_16161616,e.EnumImagePixelFormat.IPF_BGR_888].includes(E.format)){if(I(this,U,"f")===e.EnumColourChannelUsageType.CCUT_RGB_R_CHANNEL_ONLY){y._onLog&&y._onLog("only get R channel data.");const _=new Uint8Array(E.width*E.height);for(let t=0;t<_.length;t++)switch(E.format){case e.EnumImagePixelFormat.IPF_RGB_565:case e.EnumImagePixelFormat.IPF_RGB_555:case e.EnumImagePixelFormat.IPF_RGB_888:case e.EnumImagePixelFormat.IPF_RGB_161616:_[t]=E.bytes[3*t+2];break;case e.EnumImagePixelFormat.IPF_ARGB_8888:case e.EnumImagePixelFormat.IPF_ARGB_16161616:_[t]=E.bytes[4*t+2];break;case e.EnumImagePixelFormat.IPF_BGR_888:_[t]=E.bytes[3*t];break;case e.EnumImagePixelFormat.IPF_ABGR_8888:case e.EnumImagePixelFormat.IPF_ABGR_16161616:_[t]=E.bytes[4*t]}E.bytes=_,E.stride=E.width,E.format=e.EnumImagePixelFormat.IPF_GRAYSCALED}else if(I(this,U,"f")===e.EnumColourChannelUsageType.CCUT_RGB_G_CHANNEL_ONLY){y._onLog&&y._onLog("only get G channel data.");const _=new Uint8Array(E.width*E.height);for(let t=0;t<_.length;t++)switch(E.format){case e.EnumImagePixelFormat.IPF_RGB_565:case e.EnumImagePixelFormat.IPF_RGB_555:case e.EnumImagePixelFormat.IPF_RGB_888:case e.EnumImagePixelFormat.IPF_RGB_161616:case e.EnumImagePixelFormat.IPF_BGR_888:_[t]=E.bytes[3*t+1];break;case e.EnumImagePixelFormat.IPF_ARGB_8888:case e.EnumImagePixelFormat.IPF_ARGB_16161616:case e.EnumImagePixelFormat.IPF_ABGR_8888:case e.EnumImagePixelFormat.IPF_ABGR_16161616:_[t]=E.bytes[4*t+1]}E.bytes=_,E.stride=E.width,E.format=e.EnumImagePixelFormat.IPF_GRAYSCALED}else if(I(this,U,"f")===e.EnumColourChannelUsageType.CCUT_RGB_B_CHANNEL_ONLY){y._onLog&&y._onLog("only get B channel data.");const _=new Uint8Array(E.width*E.height);for(let t=0;t<_.length;t++)switch(E.format){case e.EnumImagePixelFormat.IPF_RGB_565:case e.EnumImagePixelFormat.IPF_RGB_555:case e.EnumImagePixelFormat.IPF_RGB_888:case e.EnumImagePixelFormat.IPF_RGB_161616:_[t]=E.bytes[3*t];break;case e.EnumImagePixelFormat.IPF_ARGB_8888:case e.EnumImagePixelFormat.IPF_ARGB_16161616:_[t]=E.bytes[4*t];break;case e.EnumImagePixelFormat.IPF_BGR_888:_[t]=E.bytes[3*t+2];break;case e.EnumImagePixelFormat.IPF_ABGR_8888:case e.EnumImagePixelFormat.IPF_ABGR_16161616:_[t]=E.bytes[4*t+2]}E.bytes=_,E.stride=E.width,E.format=e.EnumImagePixelFormat.IPF_GRAYSCALED}}else[e.EnumImagePixelFormat.IPF_NV21,e.EnumImagePixelFormat.IPF_NV12].includes(E.format)&&y._onLog&&y._onLog("NV21 or NV12 is not supported.");return E}setNextImageToReturn(e,E){if(!((...e)=>0!==e.length&&e.every((e=>L(e))))(e))throw new TypeError("Invalid 'imageId'.");if(void 0!==E&&!R(E))throw new TypeError("Invalid 'keepInBuffer'.");r(this,G,{imageId:e,keepInBuffer:E},"f")}_resetNextReturnedImage(){r(this,G,null,"f")}hasImage(e){return I(this,P,"m",p).call(this,e)>=0}startFetching(){r(this,M,!0,"f")}stopFetching(){r(this,M,!1,"f")}setMaxImageCount(e){if("number"!=typeof e)throw new TypeError("Invalid 'count'.");if(e<1||Math.round(e)!==e)throw new Error("Invalid 'count'.");for(r(this,F,e,"f");I(this,f,"f")&&I(this,f,"f").length>e;)I(this,f,"f").shift()}getMaxImageCount(){return I(this,F,"f")}getImageCount(){return I(this,f,"f").length}clearBuffer(){I(this,f,"f").length=0}isBufferEmpty(){return 0===I(this,f,"f").length}setBufferOverflowProtectionMode(e){r(this,h,e,"f")}getBufferOverflowProtectionMode(){return I(this,h,"f")}setColourChannelUsageType(e){r(this,U,e,"f")}getColourChannelUsageType(){return I(this,U,"f")}}let B,w,V,b,v;f=new WeakMap,F=new WeakMap,h=new WeakMap,M=new WeakMap,G=new WeakMap,U=new WeakMap,P=new WeakSet,p=function(e){if("number"!=typeof e)throw new TypeError("Invalid 'imageId'.");return I(this,f,"f").findIndex((E=>{var _;return(null===(_=E.tag)||void 0===_?void 0:_.imageId)===e}))},"undefined"!=typeof navigator&&(B=navigator,w=B.userAgent,V=B.platform,b=B.mediaDevices),function(){if(!s){const e={Edge:{search:"Edg",verSearch:"Edg"},OPR:null,Chrome:null,Safari:{str:B.vendor,search:"Apple",verSearch:["Version","iPhone OS","CPU OS"]},Firefox:null,Explorer:{search:"MSIE",verSearch:"MSIE"}},E={HarmonyOS:null,Android:null,iPhone:null,iPad:null,Windows:{str:V,search:"Win"},Mac:{str:V},Linux:{str:V}};let _="unknownBrowser",t=0,I="unknownOS";for(let E in e){const I=e[E]||{};let r=I.str||w,n=I.search||E,o=I.verStr||w,a=I.verSearch||E;if(a instanceof Array||(a=[a]),-1!=r.indexOf(n)){_=E;for(let e of a){let E=o.indexOf(e);if(-1!=E){t=parseFloat(o.substring(E+e.length+1));break}}break}}for(let e in E){const _=E[e]||{};let t=_.str||w,r=_.search||e;if(-1!=t.indexOf(r)){I=e;break}}"Linux"==I&&-1!=w.indexOf("Windows NT")&&(I="HarmonyOS"),v={browser:_,version:t,OS:I}}s&&(v={browser:"ssr",version:0,OS:"ssr"})}();const x="undefined"!=typeof WebAssembly&&w&&!(/Safari/.test(w)&&!/Chrome/.test(w)&&/\(.+\s11_2_([2-6]).*\)/.test(w)),k=!("undefined"==typeof Worker),Y=!(!b||!b.getUserMedia),H=async()=>{let e=!1;if(Y)try{(await b.getUserMedia({video:!0})).getTracks().forEach((e=>{e.stop()})),e=!0}catch(e){}return e};"Chrome"===v.browser&&v.version>66||"Safari"===v.browser&&v.version>13||"OPR"===v.browser&&v.version>43||"Edge"===v.browser&&v.version;const X={},Z=async e=>{let E="string"==typeof e?[e]:e,_=[];for(let e of E)_.push(X[e]=X[e]||new t);await Promise.all(_)},W=async(e,E)=>{let _,I="string"==typeof e?[e]:e,r=[];for(let e of I){let I;r.push(I=X[e]=X[e]||new t(_=_||E())),I.isEmpty&&(I.task=_=_||E())}await Promise.all(r)};e.worker=void 0;let j=0;const K=()=>j++,J={};e.onLog=void 0;const Q=E=>{e.onLog=E,e.worker&&e.worker.postMessage({type:"setBLog",body:{value:!!E}})};e.bDebug=!1;const $=E=>{e.bDebug=E,e.worker&&e.worker.postMessage({type:"setBDebug",body:{value:!!E}})},z={},q={dip:{wasm:!0}},ee={std:{version:"1.4.21",path:A(C+"../../dynamsoft-capture-vision-std@1.4.21/dist/"),isInternal:!0},core:{version:"3.4.31",path:C,isInternal:!0}},Ee=async E=>{let _;E instanceof Array||(E=E?[E]:[]);let I=X.core;_=!I||I.isEmpty;let r=new Map;const n=e=>{if("std"==(e=e.toLowerCase())||"core"==e)return;if(!q[e])throw Error("The '"+e+"' module cannot be found.");let E=q[e].deps;if(null==E?void 0:E.length)for(let e of E)n(e);let _=X[e];r.has(e)||r.set(e,!_||_.isEmpty)};for(let e of E)n(e);let o=[];_&&o.push("core"),o.push(...r.keys());const a=[...r.entries()].filter((e=>!e[1])).map((e=>e[0]));await W(o,(async()=>{const E=[...r.entries()].filter((e=>e[1])).map((e=>e[0]));await Z(a);const I=u(ee),n={};for(let e of E)n[e]=q[e];const o={engineResourcePaths:I,autoResources:n,names:E};let s=new t;if(_){o.needLoadCore=!0;let E=I.core+_e._workerName;E.startsWith(location.origin)||(E=await fetch(E).then((e=>e.blob())).then((e=>URL.createObjectURL(e)))),e.worker=new Worker(E),e.worker.onerror=e=>{let E=new Error(e.message);s.reject(E)},e.worker.addEventListener("message",(E=>{let _=E.data?E.data:E,t=_.type,I=_.id,r=_.body;switch(t){case"log":e.onLog&&e.onLog(_.message);break;case"task":try{J[I](r),delete J[I]}catch(e){throw delete J[I],e}break;case"event":try{J[I](r)}catch(e){throw e}break;default:console.log(E)}})),o.bLog=!!e.onLog,o.bd=e.bDebug,o.dm=location.origin.startsWith("http")?location.origin:"https://localhost"}else await Z("core");let i=j++;J[i]=e=>{if(e.success)Object.assign(z,e.versions),"{}"!==JSON.stringify(e.versions)&&(_e._versions=e.versions),s.resolve(void 0);else{const E=Error(e.message);e.stack&&(E.stack=e.stack),s.reject(E)}},e.worker.postMessage({type:"loadWasm",body:o,id:i}),await s}))};class _e{static get engineResourcePaths(){return ee}static set engineResourcePaths(e){Object.assign(ee,e)}static get bSupportDce4Module(){return this._bSupportDce4Module}static get bSupportIRTModule(){return this._bSupportIRTModule}static get versions(){return this._versions}static get _onLog(){return e.onLog}static set _onLog(e){Q(e)}static get _bDebug(){return e.bDebug}static set _bDebug(e){$(e)}static isModuleLoaded(e){return e=(e=e||"core").toLowerCase(),!!X[e]&&X[e].isFulfilled}static async loadWasm(e){return await Ee(e)}static async detectEnvironment(){return await(async()=>({wasm:x,worker:k,getUserMedia:Y,camera:await H(),browser:v.browser,version:v.version,OS:v.OS}))()}static async getModuleVersion(){return await new Promise(((E,_)=>{let t=K();J[t]=async e=>{if(e.success)return E(e.versions);{let E=new Error(e.message);return E.stack=e.stack+"\n"+E.stack,_(E)}},e.worker.postMessage({type:"getModuleVersion",id:t})}))}static getVersion(){const e=z.core&&z.core.worker,E=z.core&&z.core.wasm;return`3.4.31(Worker: ${e||"Not Loaded"}, Wasm: ${E||"Not Loaded"})`}static enableLogging(){y._onLog=console.log,_e._onLog=console.log}static disableLogging(){y._onLog=null,_e._onLog=null}static async cfd(E){return await new Promise(((_,t)=>{let I=K();J[I]=async e=>{if(e.success)return _();{let E=new Error(e.message);return E.stack=e.stack+"\n"+E.stack,t(E)}},e.worker.postMessage({type:"cfd",id:I,body:{count:E}})}))}}var te,Ie,re,ne,oe,ae,se,ie,Ce;_e._bSupportDce4Module=-1,_e._bSupportIRTModule=-1,_e._versions=null,_e._workerName="core.worker.js",_e.browserInfo=v,e.EnumCapturedResultItemType=void 0,(te=e.EnumCapturedResultItemType||(e.EnumCapturedResultItemType={}))[te.CRIT_ORIGINAL_IMAGE=1]="CRIT_ORIGINAL_IMAGE",te[te.CRIT_BARCODE=2]="CRIT_BARCODE",te[te.CRIT_TEXT_LINE=4]="CRIT_TEXT_LINE",te[te.CRIT_DETECTED_QUAD=8]="CRIT_DETECTED_QUAD",te[te.CRIT_NORMALIZED_IMAGE=16]="CRIT_NORMALIZED_IMAGE",te[te.CRIT_PARSED_RESULT=32]="CRIT_PARSED_RESULT",e.EnumCornerType=void 0,(Ie=e.EnumCornerType||(e.EnumCornerType={}))[Ie.CT_NORMAL_INTERSECTED=0]="CT_NORMAL_INTERSECTED",Ie[Ie.CT_T_INTERSECTED=1]="CT_T_INTERSECTED",Ie[Ie.CT_CROSS_INTERSECTED=2]="CT_CROSS_INTERSECTED",Ie[Ie.CT_NOT_INTERSECTED=3]="CT_NOT_INTERSECTED",e.EnumErrorCode=void 0,(re=e.EnumErrorCode||(e.EnumErrorCode={}))[re.EC_OK=0]="EC_OK",re[re.EC_UNKNOWN=-1e4]="EC_UNKNOWN",re[re.EC_NO_MEMORY=-10001]="EC_NO_MEMORY",re[re.EC_NULL_POINTER=-10002]="EC_NULL_POINTER",re[re.EC_LICENSE_INVALID=-10003]="EC_LICENSE_INVALID",re[re.EC_LICENSE_EXPIRED=-10004]="EC_LICENSE_EXPIRED",re[re.EC_FILE_NOT_FOUND=-10005]="EC_FILE_NOT_FOUND",re[re.EC_FILE_TYPE_NOT_SUPPORTED=-10006]="EC_FILE_TYPE_NOT_SUPPORTED",re[re.EC_BPP_NOT_SUPPORTED=-10007]="EC_BPP_NOT_SUPPORTED",re[re.EC_INDEX_INVALID=-10008]="EC_INDEX_INVALID",re[re.EC_CUSTOM_REGION_INVALID=-10010]="EC_CUSTOM_REGION_INVALID",re[re.EC_IMAGE_READ_FAILED=-10012]="EC_IMAGE_READ_FAILED",re[re.EC_TIFF_READ_FAILED=-10013]="EC_TIFF_READ_FAILED",re[re.EC_DIB_BUFFER_INVALID=-10018]="EC_DIB_BUFFER_INVALID",re[re.EC_PDF_READ_FAILED=-10021]="EC_PDF_READ_FAILED",re[re.EC_PDF_DLL_MISSING=-10022]="EC_PDF_DLL_MISSING",re[re.EC_PAGE_NUMBER_INVALID=-10023]="EC_PAGE_NUMBER_INVALID",re[re.EC_CUSTOM_SIZE_INVALID=-10024]="EC_CUSTOM_SIZE_INVALID",re[re.EC_TIMEOUT=-10026]="EC_TIMEOUT",re[re.EC_JSON_PARSE_FAILED=-10030]="EC_JSON_PARSE_FAILED",re[re.EC_JSON_TYPE_INVALID=-10031]="EC_JSON_TYPE_INVALID",re[re.EC_JSON_KEY_INVALID=-10032]="EC_JSON_KEY_INVALID",re[re.EC_JSON_VALUE_INVALID=-10033]="EC_JSON_VALUE_INVALID",re[re.EC_JSON_NAME_KEY_MISSING=-10034]="EC_JSON_NAME_KEY_MISSING",re[re.EC_JSON_NAME_VALUE_DUPLICATED=-10035]="EC_JSON_NAME_VALUE_DUPLICATED",re[re.EC_TEMPLATE_NAME_INVALID=-10036]="EC_TEMPLATE_NAME_INVALID",re[re.EC_JSON_NAME_REFERENCE_INVALID=-10037]="EC_JSON_NAME_REFERENCE_INVALID",re[re.EC_PARAMETER_VALUE_INVALID=-10038]="EC_PARAMETER_VALUE_INVALID",re[re.EC_DOMAIN_NOT_MATCH=-10039]="EC_DOMAIN_NOT_MATCH",re[re.EC_RESERVED_INFO_NOT_MATCH=-10040]="EC_RESERVED_INFO_NOT_MATCH",re[re.EC_LICENSE_KEY_NOT_MATCH=-10043]="EC_LICENSE_KEY_NOT_MATCH",re[re.EC_REQUEST_FAILED=-10044]="EC_REQUEST_FAILED",re[re.EC_LICENSE_INIT_FAILED=-10045]="EC_LICENSE_INIT_FAILED",re[re.EC_SET_MODE_ARGUMENT_ERROR=-10051]="EC_SET_MODE_ARGUMENT_ERROR",re[re.EC_LICENSE_CONTENT_INVALID=-10052]="EC_LICENSE_CONTENT_INVALID",re[re.EC_LICENSE_KEY_INVALID=-10053]="EC_LICENSE_KEY_INVALID",re[re.EC_LICENSE_DEVICE_RUNS_OUT=-10054]="EC_LICENSE_DEVICE_RUNS_OUT",re[re.EC_GET_MODE_ARGUMENT_ERROR=-10055]="EC_GET_MODE_ARGUMENT_ERROR",re[re.EC_IRT_LICENSE_INVALID=-10056]="EC_IRT_LICENSE_INVALID",re[re.EC_FILE_SAVE_FAILED=-10058]="EC_FILE_SAVE_FAILED",re[re.EC_STAGE_TYPE_INVALID=-10059]="EC_STAGE_TYPE_INVALID",re[re.EC_IMAGE_ORIENTATION_INVALID=-10060]="EC_IMAGE_ORIENTATION_INVALID",re[re.EC_CONVERT_COMPLEX_TEMPLATE_ERROR=-10061]="EC_CONVERT_COMPLEX_TEMPLATE_ERROR",re[re.EC_CALL_REJECTED_WHEN_CAPTURING=-10062]="EC_CALL_REJECTED_WHEN_CAPTURING",re[re.EC_NO_IMAGE_SOURCE=-10063]="EC_NO_IMAGE_SOURCE",re[re.EC_READ_DIRECTORY_FAILED=-10064]="EC_READ_DIRECTORY_FAILED",re[re.EC_MODULE_NOT_FOUND=-10065]="EC_MODULE_NOT_FOUND",re[re.EC_MULTI_PAGES_NOT_SUPPORTED=-10066]="EC_MULTI_PAGES_NOT_SUPPORTED",re[re.EC_FILE_ALREADY_EXISTS=-10067]="EC_FILE_ALREADY_EXISTS",re[re.EC_CREATE_FILE_FAILED=-10068]="EC_CREATE_FILE_FAILED",re[re.EC_IMGAE_DATA_INVALID=-10069]="EC_IMGAE_DATA_INVALID",re[re.EC_IMAGE_SIZE_NOT_MATCH=-10070]="EC_IMAGE_SIZE_NOT_MATCH",re[re.EC_IMAGE_PIXEL_FORMAT_NOT_MATCH=-10071]="EC_IMAGE_PIXEL_FORMAT_NOT_MATCH",re[re.EC_SECTION_LEVEL_RESULT_IRREPLACEABLE=-10072]="EC_SECTION_LEVEL_RESULT_IRREPLACEABLE",re[re.EC_AXIS_DEFINITION_INCORRECT=-10073]="EC_AXIS_DEFINITION_INCORRECT",re[re.EC_RESULT_TYPE_MISMATCH_IRREPLACEABLE=-10074]="EC_RESULT_TYPE_MISMATCH_IRREPLACEABLE",re[re.EC_PDF_LIBRARY_LOAD_FAILED=-10075]="EC_PDF_LIBRARY_LOAD_FAILED",re[re.EC_NO_LICENSE=-2e4]="EC_NO_LICENSE",re[re.EC_HANDSHAKE_CODE_INVALID=-20001]="EC_HANDSHAKE_CODE_INVALID",re[re.EC_LICENSE_BUFFER_FAILED=-20002]="EC_LICENSE_BUFFER_FAILED",re[re.EC_LICENSE_SYNC_FAILED=-20003]="EC_LICENSE_SYNC_FAILED",re[re.EC_DEVICE_NOT_MATCH=-20004]="EC_DEVICE_NOT_MATCH",re[re.EC_BIND_DEVICE_FAILED=-20005]="EC_BIND_DEVICE_FAILED",re[re.EC_INSTANCE_COUNT_OVER_LIMIT=-20008]="EC_INSTANCE_COUNT_OVER_LIMIT",re[re.EC_LICENSE_INIT_SEQUENCE_FAILED=-20009]="EC_LICENSE_INIT_SEQUENCE_FAILED",re[re.EC_TRIAL_LICENSE=-20010]="EC_TRIAL_LICENSE",re[re.EC_FAILED_TO_REACH_DLS=-20200]="EC_FAILED_TO_REACH_DLS",re[re.EC_LICENSE_CACHE_USED=-20012]="EC_LICENSE_CACHE_USED",re[re.EC_BARCODE_FORMAT_INVALID=-30009]="EC_BARCODE_FORMAT_INVALID",re[re.EC_QR_LICENSE_INVALID=-30016]="EC_QR_LICENSE_INVALID",re[re.EC_1D_LICENSE_INVALID=-30017]="EC_1D_LICENSE_INVALID",re[re.EC_PDF417_LICENSE_INVALID=-30019]="EC_PDF417_LICENSE_INVALID",re[re.EC_DATAMATRIX_LICENSE_INVALID=-30020]="EC_DATAMATRIX_LICENSE_INVALID",re[re.EC_CUSTOM_MODULESIZE_INVALID=-30025]="EC_CUSTOM_MODULESIZE_INVALID",re[re.EC_AZTEC_LICENSE_INVALID=-30041]="EC_AZTEC_LICENSE_INVALID",re[re.EC_PATCHCODE_LICENSE_INVALID=-30046]="EC_PATCHCODE_LICENSE_INVALID",re[re.EC_POSTALCODE_LICENSE_INVALID=-30047]="EC_POSTALCODE_LICENSE_INVALID",re[re.EC_DPM_LICENSE_INVALID=-30048]="EC_DPM_LICENSE_INVALID",re[re.EC_FRAME_DECODING_THREAD_EXISTS=-30049]="EC_FRAME_DECODING_THREAD_EXISTS",re[re.EC_STOP_DECODING_THREAD_FAILED=-30050]="EC_STOP_DECODING_THREAD_FAILED",re[re.EC_MAXICODE_LICENSE_INVALID=-30057]="EC_MAXICODE_LICENSE_INVALID",re[re.EC_GS1_DATABAR_LICENSE_INVALID=-30058]="EC_GS1_DATABAR_LICENSE_INVALID",re[re.EC_GS1_COMPOSITE_LICENSE_INVALID=-30059]="EC_GS1_COMPOSITE_LICENSE_INVALID",re[re.EC_DOTCODE_LICENSE_INVALID=-30061]="EC_DOTCODE_LICENSE_INVALID",re[re.EC_PHARMACODE_LICENSE_INVALID=-30062]="EC_PHARMACODE_LICENSE_INVALID",re[re.EC_CHARACTER_MODEL_FILE_NOT_FOUND=-40100]="EC_CHARACTER_MODEL_FILE_NOT_FOUND",re[re.EC_TEXT_LINE_GROUP_LAYOUT_CONFLICT=-40101]="EC_TEXT_LINE_GROUP_LAYOUT_CONFLICT",re[re.EC_TEXT_LINE_GROUP_REGEX_CONFLICT=-40102]="EC_TEXT_LINE_GROUP_REGEX_CONFLICT",re[re.EC_QUADRILATERAL_INVALID=-50057]="EC_QUADRILATERAL_INVALID",re[re.EC_PANORAMA_LICENSE_INVALID=-70060]="EC_PANORAMA_LICENSE_INVALID",re[re.EC_RESOURCE_PATH_NOT_EXIST=-90001]="EC_RESOURCE_PATH_NOT_EXIST",re[re.EC_RESOURCE_LOAD_FAILED=-90002]="EC_RESOURCE_LOAD_FAILED",re[re.EC_CODE_SPECIFICATION_NOT_FOUND=-90003]="EC_CODE_SPECIFICATION_NOT_FOUND",re[re.EC_FULL_CODE_EMPTY=-90004]="EC_FULL_CODE_EMPTY",re[re.EC_FULL_CODE_PREPROCESS_FAILED=-90005]="EC_FULL_CODE_PREPROCESS_FAILED",re[re.EC_ZA_DL_LICENSE_INVALID=-90006]="EC_ZA_DL_LICENSE_INVALID",re[re.EC_AAMVA_DL_ID_LICENSE_INVALID=-90007]="EC_AAMVA_DL_ID_LICENSE_INVALID",re[re.EC_AADHAAR_LICENSE_INVALID=-90008]="EC_AADHAAR_LICENSE_INVALID",re[re.EC_MRTD_LICENSE_INVALID=-90009]="EC_MRTD_LICENSE_INVALID",re[re.EC_VIN_LICENSE_INVALID=-90010]="EC_VIN_LICENSE_INVALID",re[re.EC_CUSTOMIZED_CODE_TYPE_LICENSE_INVALID=-90011]="EC_CUSTOMIZED_CODE_TYPE_LICENSE_INVALID",re[re.EC_LICENSE_WARNING=-10076]="EC_LICENSE_WARNING",re[re.EC_BARCODE_READER_LICENSE_NOT_FOUND=-30063]="EC_BARCODE_READER_LICENSE_NOT_FOUND",re[re.EC_LABEL_RECOGNIZER_LICENSE_NOT_FOUND=-40103]="EC_LABEL_RECOGNIZER_LICENSE_NOT_FOUND",re[re.EC_DOCUMENT_NORMALIZER_LICENSE_NOT_FOUND=-50058]="EC_DOCUMENT_NORMALIZER_LICENSE_NOT_FOUND",re[re.EC_CODE_PARSER_LICENSE_NOT_FOUND=-90012]="EC_CODE_PARSER_LICENSE_NOT_FOUND",e.EnumGrayscaleEnhancementMode=void 0,(ne=e.EnumGrayscaleEnhancementMode||(e.EnumGrayscaleEnhancementMode={}))[ne.GEM_SKIP=0]="GEM_SKIP",ne[ne.GEM_AUTO=1]="GEM_AUTO",ne[ne.GEM_GENERAL=2]="GEM_GENERAL",ne[ne.GEM_GRAY_EQUALIZE=4]="GEM_GRAY_EQUALIZE",ne[ne.GEM_GRAY_SMOOTH=8]="GEM_GRAY_SMOOTH",ne[ne.GEM_SHARPEN_SMOOTH=16]="GEM_SHARPEN_SMOOTH",ne[ne.GEM_REV=-2147483648]="GEM_REV",e.EnumGrayscaleTransformationMode=void 0,(oe=e.EnumGrayscaleTransformationMode||(e.EnumGrayscaleTransformationMode={}))[oe.GTM_SKIP=0]="GTM_SKIP",oe[oe.GTM_INVERTED=1]="GTM_INVERTED",oe[oe.GTM_ORIGINAL=2]="GTM_ORIGINAL",oe[oe.GTM_AUTO=4]="GTM_AUTO",oe[oe.GTM_REV=-2147483648]="GTM_REV",e.EnumImageTagType=void 0,(ae=e.EnumImageTagType||(e.EnumImageTagType={}))[ae.ITT_FILE_IMAGE=0]="ITT_FILE_IMAGE",ae[ae.ITT_VIDEO_FRAME=1]="ITT_VIDEO_FRAME",e.EnumPDFReadingMode=void 0,(se=e.EnumPDFReadingMode||(e.EnumPDFReadingMode={}))[se.PDFRM_VECTOR=1]="PDFRM_VECTOR",se[se.PDFRM_RASTER=2]="PDFRM_RASTER",se[se.PDFRM_REV=-2147483648]="PDFRM_REV",e.EnumRasterDataSource=void 0,(ie=e.EnumRasterDataSource||(e.EnumRasterDataSource={}))[ie.RDS_RASTERIZED_PAGES=0]="RDS_RASTERIZED_PAGES",ie[ie.RDS_EXTRACTED_IMAGES=1]="RDS_EXTRACTED_IMAGES",e.EnumCrossVerificationStatus=void 0,(Ce=e.EnumCrossVerificationStatus||(e.EnumCrossVerificationStatus={}))[Ce.CVS_NOT_VERIFIED=0]="CVS_NOT_VERIFIED",Ce[Ce.CVS_PASSED=1]="CVS_PASSED",Ce[Ce.CVS_FAILED=2]="CVS_FAILED";const Ae={IRUT_NULL:BigInt(0),IRUT_COLOUR_IMAGE:BigInt(1),IRUT_SCALED_DOWN_COLOUR_IMAGE:BigInt(2),IRUT_GRAYSCALE_IMAGE:BigInt(4),IRUT_TRANSOFORMED_GRAYSCALE_IMAGE:BigInt(8),IRUT_ENHANCED_GRAYSCALE_IMAGE:BigInt(16),IRUT_PREDETECTED_REGIONS:BigInt(32),IRUT_BINARY_IMAGE:BigInt(64),IRUT_TEXTURE_DETECTION_RESULT:BigInt(128),IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE:BigInt(256),IRUT_TEXTURE_REMOVED_BINARY_IMAGE:BigInt(512),IRUT_CONTOURS:BigInt(1024),IRUT_LINE_SEGMENTS:BigInt(2048),IRUT_TEXT_ZONES:BigInt(4096),IRUT_TEXT_REMOVED_BINARY_IMAGE:BigInt(8192),IRUT_CANDIDATE_BARCODE_ZONES:BigInt(16384),IRUT_LOCALIZED_BARCODES:BigInt(32768),IRUT_SCALED_UP_BARCODE_IMAGE:BigInt(65536),IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE:BigInt(1<<17),IRUT_COMPLEMENTED_BARCODE_IMAGE:BigInt(1<<18),IRUT_DECODED_BARCODES:BigInt(1<<19),IRUT_LONG_LINES:BigInt(1<<20),IRUT_CORNERS:BigInt(1<<21),IRUT_CANDIDATE_QUAD_EDGES:BigInt(1<<22),IRUT_DETECTED_QUADS:BigInt(1<<23),IRUT_LOCALIZED_TEXT_LINES:BigInt(1<<24),IRUT_RECOGNIZED_TEXT_LINES:BigInt(1<<25),IRUT_NORMALIZED_IMAGES:BigInt(1<<26),IRUT_SHORT_LINES:BigInt(1<<27),IRUT_RAW_TEXT_LINES:BigInt(1<<28),IRUT_LOGIC_LINES:BigInt(1<<29),IRUT_ALL:BigInt("0xFFFFFFFFFFFFFFFF")};var Te,Ne;e.EnumRegionObjectElementType=void 0,(Te=e.EnumRegionObjectElementType||(e.EnumRegionObjectElementType={}))[Te.ROET_PREDETECTED_REGION=0]="ROET_PREDETECTED_REGION",Te[Te.ROET_LOCALIZED_BARCODE=1]="ROET_LOCALIZED_BARCODE",Te[Te.ROET_DECODED_BARCODE=2]="ROET_DECODED_BARCODE",Te[Te.ROET_LOCALIZED_TEXT_LINE=3]="ROET_LOCALIZED_TEXT_LINE",Te[Te.ROET_RECOGNIZED_TEXT_LINE=4]="ROET_RECOGNIZED_TEXT_LINE",Te[Te.ROET_DETECTED_QUAD=5]="ROET_DETECTED_QUAD",Te[Te.ROET_NORMALIZED_IMAGE=6]="ROET_NORMALIZED_IMAGE",Te[Te.ROET_SOURCE_IMAGE=7]="ROET_SOURCE_IMAGE",Te[Te.ROET_TARGET_ROI=8]="ROET_TARGET_ROI",e.EnumSectionType=void 0,(Ne=e.EnumSectionType||(e.EnumSectionType={}))[Ne.ST_NULL=0]="ST_NULL",Ne[Ne.ST_REGION_PREDETECTION=1]="ST_REGION_PREDETECTION",Ne[Ne.ST_BARCODE_LOCALIZATION=2]="ST_BARCODE_LOCALIZATION",Ne[Ne.ST_BARCODE_DECODING=3]="ST_BARCODE_DECODING",Ne[Ne.ST_TEXT_LINE_LOCALIZATION=4]="ST_TEXT_LINE_LOCALIZATION",Ne[Ne.ST_TEXT_LINE_RECOGNITION=5]="ST_TEXT_LINE_RECOGNITION",Ne[Ne.ST_DOCUMENT_DETECTION=6]="ST_DOCUMENT_DETECTION",Ne[Ne.ST_DOCUMENT_NORMALIZATION=7]="ST_DOCUMENT_NORMALIZATION",e.CoreModule=_e,e.EnumIntermediateResultUnitType=Ae,e.ImageSourceAdapter=y,e._getNorImageData=d,e._saveToFile=async(e,E,_)=>await new Promise((async(t,I)=>{try{const I=E.split(".");let r=I[I.length-1];const n=await g(`image/${r}`,e);I.length<=1&&(r="png");const o=new File([n],E,{type:`image/${r}`});if(_){const e=URL.createObjectURL(o),_=document.createElement("a");_.href=e,_.download=E,_.click()}return t(o)}catch(e){return I()}})),e._toBlob=g,e._toCanvas=S,e._toImage=(e,E)=>{l(E)&&(E=d(E));const _=S(E);let t=new Image,I=_.toDataURL(e);return t.src=I,t},e.checkIsLink=e=>/^(https:\/\/www\.|http:\/\/www\.|https:\/\/|http:\/\/)|^[a-zA-Z0-9]{2,}(\.[a-zA-Z0-9]{2,})(\.[a-zA-Z0-9]{2,})?/.test(e),e.compareVersion=(e,E)=>{let _=e.split("."),t=E.split(".");for(let e=0;e<_.length&&e<t.length;++e){let E=_[e],I=t[e];if(E===I)continue;let r=parseInt(_[e]),n=parseInt(t[e]);return r===n||Number.isNaN(r)&&Number.isNaN(n)?E<I?-1:1:r<n||Number.isNaN(r)&&Number.isInteger(n)?-1:1}return _.length===t.length?0:_.length<t.length?-1:1},e.doOrWaitAsyncDependency=W,e.getNextTaskID=K,e.handleEngineResourcePaths=u,e.innerVersions=z,e.isArc=e=>!!D(e)&&(!!L(e.x)&&(!!L(e.y)&&(!!L(e.radius)&&(!(e.radius<0)&&(!!L(e.startAngle)&&!!L(e.endAngle)))))),e.isContour=e=>!!D(e)&&(!!N(e.points)&&(0!=e.points.length&&!e.points.some((e=>!c(e))))),e.isDSImageData=l,e.isDSRect=e=>!!D(e)&&(!!L(e.left)&&(!(e.left<0)&&(!!L(e.top)&&(!(e.top<0)&&(!!L(e.right)&&(!(e.right<0)&&(!!L(e.bottom)&&(!(e.bottom<0)&&(!(e.left>=e.right)&&(!(e.top>=e.bottom)&&!!R(e.isMeasuredInPercentage))))))))))),e.isImageTag=m,e.isLineSegment=e=>!!D(e)&&(!!c(e.startPoint)&&(!!c(e.endPoint)&&(e.startPoint.x!=e.endPoint.x||e.startPoint.y!=e.endPoint.y))),e.isObject=D,e.isOriginalDsImageData=e=>!!O(e)&&!(!L(e.bytes.length)&&!L(e.bytes.ptr)),e.isPoint=c,e.isPolygon=e=>!!D(e)&&(!!N(e.points)&&(0!=e.points.length&&!e.points.some((e=>!c(e))))),e.isQuad=e=>!!D(e)&&(!!N(e.points)&&(0!=e.points.length&&4==e.points.length&&!e.points.some((e=>!c(e))))),e.isRect=e=>!!D(e)&&(!!L(e.x)&&(!!L(e.y)&&(!!L(e.width)&&(!(e.width<0)&&(!!L(e.height)&&(!(e.height<0)&&!("isMeasuredInPercentage"in e&&!R(e.isMeasuredInPercentage)))))))),e.loadWasm=Ee,e.mapAsyncDependency=X,e.mapPackageRegister={},e.mapTaskCallBack=J,e.requestResource=async(e,E)=>await new Promise(((_,t)=>{let I=new XMLHttpRequest;I.open("GET",e,!0),I.responseType=E,I.send(),I.onloadend=async()=>{I.status<200||I.status>=300?t(new Error(e+" "+I.status)):_(I.response)},I.onerror=()=>{t(new Error("Network Error: "+I.statusText))}})),e.setBDebug=$,e.setOnLog=Q,e.waitAsyncDependency=Z,e.workerAutoResources=q}));
