/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft License JS Edition
 * @website https://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version 3.4.31
 * @fileoverview Dynamsoft JavaScript Library for Core
 * More info DL JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/license/license-module.html
 */
!function(){"use strict";const e="undefined"==typeof self,t=e?{}:self;let r,n,o,i,a;"undefined"!=typeof navigator&&(r=navigator,n=r.userAgent,o=r.platform,i=r.mediaDevices),function(){if(!e){const e={Edge:{search:"Edg",verSearch:"Edg"},OPR:null,Chrome:null,Safari:{str:r.vendor,search:"Apple",verSearch:["Version","iPhone OS","CPU OS"]},Firefox:null,Explorer:{search:"MSIE",verSearch:"MSIE"}},t={HarmonyOS:null,Android:null,iPhone:null,iPad:null,Windows:{str:o,search:"Win"},Mac:{str:o},Linux:{str:o}};let i="unknownBrowser",s=0,c="unknownOS";for(let t in e){const r=e[t]||{};let o=r.str||n,a=r.search||t,c=r.verStr||n,l=r.verSearch||t;if(l instanceof Array||(l=[l]),-1!=o.indexOf(a)){i=t;for(let e of l){let t=c.indexOf(e);if(-1!=t){s=parseFloat(c.substring(t+e.length+1));break}}break}}for(let e in t){const r=t[e]||{};let o=r.str||n,i=r.search||e;if(-1!=o.indexOf(i)){c=e;break}}"Linux"==c&&-1!=n.indexOf("Windows NT")&&(c="HarmonyOS"),a={browser:i,version:s,OS:c}}e&&(a={browser:"ssr",version:0,OS:"ssr"})}(),i&&i.getUserMedia;const s="Chrome"===a.browser&&a.version>66||"Safari"===a.browser&&a.version>13||"OPR"===a.browser&&a.version>43||"Edge"===a.browser&&a.version>15;var c=function(){try{if("undefined"!=typeof indexedDB)return indexedDB;if("undefined"!=typeof webkitIndexedDB)return webkitIndexedDB;if("undefined"!=typeof mozIndexedDB)return mozIndexedDB;if("undefined"!=typeof OIndexedDB)return OIndexedDB;if("undefined"!=typeof msIndexedDB)return msIndexedDB}catch(e){return}}();function l(e,t){e=e||[],t=t||{};try{return new Blob(e,t)}catch(o){if("TypeError"!==o.name)throw o;for(var r=new("undefined"!=typeof BlobBuilder?BlobBuilder:"undefined"!=typeof MSBlobBuilder?MSBlobBuilder:"undefined"!=typeof MozBlobBuilder?MozBlobBuilder:WebKitBlobBuilder),n=0;n<e.length;n+=1)r.append(e[n]);return r.getBlob(t.type)}}function d(e,t){t&&e.then((function(e){t(null,e)}),(function(e){t(e)}))}function u(e,t,r){"function"==typeof t&&e.then(t),"function"==typeof r&&e.catch(r)}function f(e){return"string"!=typeof e&&(console.warn(`${e} used as a key, but it is not a string.`),e=String(e)),e}function h(){if(arguments.length&&"function"==typeof arguments[arguments.length-1])return arguments[arguments.length-1]}const m="local-forage-detect-blob-support";let y;const p={},g=Object.prototype.toString,v="readonly",b="readwrite";function w(e){return"boolean"==typeof y?Promise.resolve(y):function(e){return new Promise((function(t){var r=e.transaction(m,b),n=l([""]);r.objectStore(m).put(n,"key"),r.onabort=function(e){e.preventDefault(),e.stopPropagation(),t(!1)},r.oncomplete=function(){var e=navigator.userAgent.match(/Chrome\/(\d+)/),r=navigator.userAgent.match(/Edge\//);t(r||!e||parseInt(e[1],10)>=43)}})).catch((function(){return!1}))}(e).then((function(e){return y=e,y}))}function _(e){var t=p[e.name],r={};r.promise=new Promise((function(e,t){r.resolve=e,r.reject=t})),t.deferredOperations.push(r),t.dbReady?t.dbReady=t.dbReady.then((function(){return r.promise})):t.dbReady=r.promise}function S(e){var t=p[e.name].deferredOperations.pop();if(t)return t.resolve(),t.promise}function I(e,t){var r=p[e.name].deferredOperations.pop();if(r)return r.reject(t),r.promise}function x(e,t){return new Promise((function(r,n){if(p[e.name]=p[e.name]||{forages:[],db:null,dbReady:null,deferredOperations:[]},e.db){if(!t)return r(e.db);_(e),e.db.close()}var o=[e.name];t&&o.push(e.version);var i=c.open.apply(c,o);t&&(i.onupgradeneeded=function(t){var r=i.result;try{r.createObjectStore(e.storeName),t.oldVersion<=1&&r.createObjectStore(m)}catch(r){if("ConstraintError"!==r.name)throw r;console.warn('The database "'+e.name+'" has been upgraded from version '+t.oldVersion+" to version "+t.newVersion+', but the storage "'+e.storeName+'" already exists.')}}),i.onerror=function(e){e.preventDefault(),n(i.error)},i.onsuccess=function(){var t=i.result;t.onversionchange=function(e){e.target.close()},r(t),S(e)}}))}function k(e){return x(e,!1)}function C(e){return x(e,!0)}function D(e,t){if(!e.db)return!0;var r=!e.db.objectStoreNames.contains(e.storeName),n=e.version<e.db.version,o=e.version>e.db.version;if(n&&(e.version!==t&&console.warn('The database "'+e.name+"\" can't be downgraded from version "+e.db.version+" to version "+e.version+"."),e.version=e.db.version),o||r){if(r){var i=e.db.version+1;i>e.version&&(e.version=i)}return!0}return!1}function P(e){var t=function(e){for(var t=e.length,r=new ArrayBuffer(t),n=new Uint8Array(r),o=0;o<t;o++)n[o]=e.charCodeAt(o);return r}(atob(e.data));return l([t],{type:e.type})}function T(e){var t=this,r=t._initReady().then((function(){var e=p[t._dbInfo.name];if(e&&e.dbReady)return e.dbReady}));return u(r,e,e),r}function N(e,t,r,n){void 0===n&&(n=1);try{var o=e.db.transaction(e.storeName,t);r(null,o)}catch(o){if(n>0&&(!e.db||"InvalidStateError"===o.name||"NotFoundError"===o.name))return Promise.resolve().then((()=>{if(!e.db||"NotFoundError"===o.name&&!e.db.objectStoreNames.contains(e.storeName)&&e.version<=e.db.version)return e.db&&(e.version=e.db.version+1),C(e)})).then((()=>function(e){_(e);for(var t=p[e.name],r=t.forages,n=0;n<r.length;n++){const e=r[n];e._dbInfo.db&&(e._dbInfo.db.close(),e._dbInfo.db=null)}return e.db=null,k(e).then((t=>(e.db=t,D(e)?C(e):t))).then((n=>{e.db=t.db=n;for(var o=0;o<r.length;o++)r[o]._dbInfo.db=n})).catch((t=>{throw I(e,t),t}))}(e).then((function(){N(e,t,r,n-1)})))).catch(r);r(o)}}var E={_driver:"asyncStorage",_initStorage:function(e){var t=this,r={db:null};if(e)for(var n in e)r[n]=e[n];var o=p[r.name];o||(o={forages:[],db:null,dbReady:null,deferredOperations:[]},p[r.name]=o),o.forages.push(t),t._initReady||(t._initReady=t.ready,t.ready=T);var i=[];function a(){return Promise.resolve()}for(var s=0;s<o.forages.length;s++){var c=o.forages[s];c!==t&&i.push(c._initReady().catch(a))}var l=o.forages.slice(0);return Promise.all(i).then((function(){return r.db=o.db,k(r)})).then((function(e){return r.db=e,D(r,t._defaultConfig.version)?C(r):e})).then((function(e){r.db=o.db=e,t._dbInfo=r;for(var n=0;n<l.length;n++){var i=l[n];i!==t&&(i._dbInfo.db=r.db,i._dbInfo.version=r.version)}}))},_support:function(){try{if(!c||!c.open)return!1;var e="undefined"!=typeof openDatabase&&/(Safari|iPhone|iPad|iPod)/.test(navigator.userAgent)&&!/Chrome/.test(navigator.userAgent)&&!/BlackBerry/.test(navigator.platform),t="function"==typeof fetch&&-1!==fetch.toString().indexOf("[native code");return(!e||t)&&"undefined"!=typeof indexedDB&&"undefined"!=typeof IDBKeyRange}catch(e){return!1}}(),getItem:function(e,t){var r=this;e=f(e);var n=new Promise((function(t,n){r.ready().then((function(){N(r._dbInfo,v,(function(o,i){if(o)return n(o);try{var a=i.objectStore(r._dbInfo.storeName).get(e);a.onsuccess=function(){var e=a.result;void 0===e&&(e=null),function(e){return e&&e.__local_forage_encoded_blob}(e)&&(e=P(e)),t(e)},a.onerror=function(){n(a.error)}}catch(e){n(e)}}))})).catch(n)}));return d(n,t),n},setItem:function(e,t,r){var n=this;e=f(e);var o=new Promise((function(r,o){var i;n.ready().then((function(){return i=n._dbInfo,"[object Blob]"===g.call(t)?w(i.db).then((function(e){return e?t:(r=t,new Promise((function(e,t){var n=new FileReader;n.onerror=t,n.onloadend=function(t){var n=btoa(t.target.result||"");e({__local_forage_encoded_blob:!0,data:n,type:r.type})},n.readAsBinaryString(r)})));var r})):t})).then((function(t){N(n._dbInfo,b,(function(i,a){if(i)return o(i);try{var s=a.objectStore(n._dbInfo.storeName);null===t&&(t=void 0);var c=s.put(t,e);a.oncomplete=function(){void 0===t&&(t=null),r(t)},a.onabort=a.onerror=function(){var e=c.error?c.error:c.transaction.error;o(e)}}catch(e){o(e)}}))})).catch(o)}));return d(o,r),o},removeItem:function(e,t){var r=this;e=f(e);var n=new Promise((function(t,n){r.ready().then((function(){N(r._dbInfo,b,(function(o,i){if(o)return n(o);try{var a=i.objectStore(r._dbInfo.storeName).delete(e);i.oncomplete=function(){t()},i.onerror=function(){n(a.error)},i.onabort=function(){var e=a.error?a.error:a.transaction.error;n(e)}}catch(e){n(e)}}))})).catch(n)}));return d(n,t),n},clear:function(e){var t=this,r=new Promise((function(e,r){t.ready().then((function(){N(t._dbInfo,b,(function(n,o){if(n)return r(n);try{var i=o.objectStore(t._dbInfo.storeName).clear();o.oncomplete=function(){e()},o.onabort=o.onerror=function(){var e=i.error?i.error:i.transaction.error;r(e)}}catch(e){r(e)}}))})).catch(r)}));return d(r,e),r},length:function(e){var t=this,r=new Promise((function(e,r){t.ready().then((function(){N(t._dbInfo,v,(function(n,o){if(n)return r(n);try{var i=o.objectStore(t._dbInfo.storeName).count();i.onsuccess=function(){e(i.result)},i.onerror=function(){r(i.error)}}catch(e){r(e)}}))})).catch(r)}));return d(r,e),r},keys:function(e){var t=this,r=new Promise((function(e,r){t.ready().then((function(){N(t._dbInfo,v,(function(n,o){if(n)return r(n);try{var i=o.objectStore(t._dbInfo.storeName).openKeyCursor(),a=[];i.onsuccess=function(){var t=i.result;t?(a.push(t.key),t.continue()):e(a)},i.onerror=function(){r(i.error)}}catch(e){r(e)}}))})).catch(r)}));return d(r,e),r},dropInstance:function(e,t){t=h.apply(this,arguments);var r,n=this.config();if((e="function"!=typeof e&&e||{}).name||(e.name=e.name||n.name,e.storeName=e.storeName||n.storeName),e.name){const t=e.name===n.name&&this._dbInfo.db?Promise.resolve(this._dbInfo.db):k(e).then((t=>{const r=p[e.name],n=r.forages;r.db=t;for(var o=0;o<n.length;o++)n[o]._dbInfo.db=t;return t}));r=e.storeName?t.then((t=>{if(!t.objectStoreNames.contains(e.storeName))return;const r=t.version+1;_(e);const n=p[e.name],o=n.forages;t.close();for(let e=0;e<o.length;e++){const t=o[e];t._dbInfo.db=null,t._dbInfo.version=r}const i=new Promise(((t,n)=>{const o=c.open(e.name,r);o.onerror=e=>{o.result.close(),n(e)},o.onupgradeneeded=()=>{o.result.deleteObjectStore(e.storeName)},o.onsuccess=()=>{const e=o.result;e.close(),t(e)}}));return i.then((e=>{n.db=e;for(let t=0;t<o.length;t++){const r=o[t];r._dbInfo.db=e,S(r._dbInfo)}})).catch((t=>{throw(I(e,t)||Promise.resolve()).catch((()=>{})),t}))})):t.then((t=>{_(e);const r=p[e.name],n=r.forages;t.close();for(var o=0;o<n.length;o++){n[o]._dbInfo.db=null}const i=new Promise(((t,r)=>{var n=c.deleteDatabase(e.name);n.onerror=()=>{const e=n.result;e&&e.close(),r(n.error)},n.onblocked=()=>{console.warn('dropInstance blocked for database "'+e.name+'" until all open connections are closed')},n.onsuccess=()=>{const e=n.result;e&&e.close(),t(e)}}));return i.then((e=>{r.db=e;for(var t=0;t<n.length;t++){S(n[t]._dbInfo)}})).catch((t=>{throw(I(e,t)||Promise.resolve()).catch((()=>{})),t}))}))}else r=Promise.reject("Invalid arguments");return d(r,t),r}};const O=new Map;function M(e,t){let r=e.name+"/";return e.storeName!==t.storeName&&(r+=e.storeName+"/"),r}var R={_driver:"tempStorageWrapper",_initStorage:async function(e){const t={};if(e)for(let r in e)t[r]=e[r];const r=t.keyPrefix=M(e,this._defaultConfig);this._dbInfo=t,O.has(r)||O.set(r,new Map)},getItem:function(e,t){e=f(e);const r=this.ready().then((()=>O.get(this._dbInfo.keyPrefix).get(e)));return d(r,t),r},setItem:function(e,t,r){e=f(e);const n=this.ready().then((()=>(void 0===t&&(t=null),O.get(this._dbInfo.keyPrefix).set(e,t),t)));return d(n,r),n},removeItem:function(e,t){e=f(e);const r=this.ready().then((()=>{O.get(this._dbInfo.keyPrefix).delete(e)}));return d(r,t),r},clear:function(e){const t=this.ready().then((()=>{const e=this._dbInfo.keyPrefix;O.has(e)&&O.delete(e)}));return d(t,e),t},length:function(e){const t=this.ready().then((()=>O.get(this._dbInfo.keyPrefix).size));return d(t,e),t},keys:function(e){const t=this.ready().then((()=>[...O.get(this._dbInfo.keyPrefix).keys()]));return d(t,e),t},dropInstance:function(e,t){if(t=h.apply(this,arguments),!(e="function"!=typeof e&&e||{}).name){const t=this.config();e.name=e.name||t.name,e.storeName=e.storeName||t.storeName}let r;return r=e.name?new Promise((t=>{e.storeName?t(M(e,this._defaultConfig)):t(`${e.name}/`)})).then((e=>{O.delete(e)})):Promise.reject("Invalid arguments"),d(r,t),r}};const j=(e,t)=>{const r=e.length;let n=0;for(;n<r;){if((o=e[n])===(i=t)||"number"==typeof o&&"number"==typeof i&&isNaN(o)&&isNaN(i))return!0;n++}var o,i;return!1},B=Array.isArray||function(e){return"[object Array]"===Object.prototype.toString.call(e)},A={},U={},F={INDEXEDDB:E,TEMPSTORAGE:R},W=[F.INDEXEDDB._driver,F.TEMPSTORAGE._driver],H=["dropInstance"],J=["clear","getItem","keys","length","removeItem","setItem"].concat(H),L={description:"",driver:W.slice(),name:"localforage",size:4980736,storeName:"keyvaluepairs",version:1};function $(e,t){e[t]=function(){const r=arguments;return e.ready().then((function(){return e[t].apply(e,r)}))}}function z(){for(let e=1;e<arguments.length;e++){const t=arguments[e];if(t)for(let e in t)t.hasOwnProperty(e)&&(B(t[e])?arguments[0][e]=t[e].slice():arguments[0][e]=t[e])}return arguments[0]}class V{constructor(e){for(let e in F)if(F.hasOwnProperty(e)){const t=F[e],r=t._driver;this[e]=r,A[r]||this.defineDriver(t)}this._defaultConfig=z({},L),this._config=z({},this._defaultConfig,e),this._driverSet=null,this._initDriver=null,this._ready=!1,this._dbInfo=null,this._wrapLibraryMethodsWithReady(),this.setDriver(this._config.driver).catch((()=>{}))}config(e){if("object"==typeof e){if(this._ready)return new Error("Can't call config() after localforage has been used.");for(let t in e){if("storeName"===t&&(e[t]=e[t].replace(/\W/g,"_")),"version"===t&&"number"!=typeof e[t])return new Error("Database version must be a number.");this._config[t]=e[t]}return!("driver"in e)||!e.driver||this.setDriver(this._config.driver)}return"string"==typeof e?this._config[e]:this._config}defineDriver(e,t,r){const n=new Promise((function(t,r){try{const n=e._driver,o=new Error("Custom driver not compliant; see https://mozilla.github.io/localForage/#definedriver");if(!e._driver)return void r(o);const i=J.concat("_initStorage");for(let t=0,n=i.length;t<n;t++){const n=i[t];if((!j(H,n)||e[n])&&"function"!=typeof e[n])return void r(o)}const a=function(){const t=function(e){return function(){const t=new Error(`Method ${e} is not implemented by the current driver`),r=Promise.reject(t);return d(r,arguments[arguments.length-1]),r}};for(let r=0,n=H.length;r<n;r++){const n=H[r];e[n]||(e[n]=t(n))}};a();const s=function(r){A[n]&&console.info(`Redefining LocalForage driver: ${n}`),A[n]=e,U[n]=r,t()};"_support"in e?e._support&&"function"==typeof e._support?e._support().then(s,r):s(!!e._support):s(!0)}catch(e){r(e)}}));return u(n,t,r),n}driver(){return this._driver||null}getDriver(e,t,r){const n=A[e]?Promise.resolve(A[e]):Promise.reject(new Error("Driver not found."));return u(n,t,r),n}ready(e){const t=this,r=t._driverSet.then((()=>(null===t._ready&&(t._ready=t._initDriver()),t._ready)));return u(r,e,e),r}setDriver(e,t,r){const n=this;B(e)||(e=[e]);const o=this._getSupportedDrivers(e);function i(){n._config.driver=n.driver()}function a(e){return n._extend(e),i(),n._ready=n._initStorage(n._config),n._ready}const s=null!==this._driverSet?this._driverSet.catch((()=>Promise.resolve())):Promise.resolve();return this._driverSet=s.then((()=>{const e=o[0];return n._dbInfo=null,n._ready=null,n.getDriver(e).then((e=>{n._driver=e._driver,i(),n._wrapLibraryMethodsWithReady(),n._initDriver=function(e){return function(){let t=0;return function r(){for(;t<e.length;){let o=e[t];return t++,n._dbInfo=null,n._ready=null,n.getDriver(o).then(a).catch(r)}i();const o=new Error("No available storage method found.");return n._driverSet=Promise.reject(o),n._driverSet}()}}(o)}))})).catch((()=>{i();const e=new Error("No available storage method found.");return n._driverSet=Promise.reject(e),n._driverSet})),u(this._driverSet,t,r),this._driverSet}supports(e){return!!U[e]}_extend(e){z(this,e)}_getSupportedDrivers(e){const t=[];for(let r=0,n=e.length;r<n;r++){const n=e[r];this.supports(n)&&t.push(n)}return t}_wrapLibraryMethodsWithReady(){for(let e=0,t=J.length;e<t;e++)$(this,J[e])}createInstance(e){return new V(e)}}var Z=new V;const G=e=>e&&"object"==typeof e&&"function"==typeof e.then,K=(async()=>{})().constructor;class q extends K{get status(){return this._s}get isPending(){return"pending"===this._s}get isFulfilled(){return"fulfilled"===this._s}get isRejected(){return"rejected"===this._s}get task(){return this._task}set task(e){let t;this._task=e,G(e)?t=e:"function"==typeof e&&(t=new K(e)),t&&(async()=>{try{const r=await t;e===this._task&&this.resolve(r)}catch(t){e===this._task&&this.reject(t)}})()}get isEmpty(){return null==this._task}constructor(e){let t,r;super(((e,n)=>{t=e,r=n})),this._s="pending",this.resolve=e=>{this.isPending&&(G(e)?this.task=e:(this._s="fulfilled",t(e)))},this.reject=e=>{this.isPending&&(this._s="rejected",r(e))},this.task=e}}Date.prototype.kUtilFormat=function(e){const t={"M+":this.getUTCMonth()+1,"d+":this.getUTCDate(),"H+":this.getUTCHours(),"h+":this.getUTCHours()%12||12,"m+":this.getUTCMinutes(),"s+":this.getUTCSeconds(),"q+":Math.floor((this.getUTCMonth()+3)/3),"S+":this.getUTCMilliseconds()};/(y+)/.test(e)&&(e=e.replace(RegExp.$1,(this.getUTCFullYear()+"").substr(4-RegExp.$1.length)));for(let r in t)new RegExp("("+r+")").test(e)&&(e=e.replace(RegExp.$1,1==RegExp.$1.length?t[r]:("000"+t[r]).substr(("000"+t[r]).length-RegExp.$1.length)));return e};let X=e=>{let r,n,o,i,a,c,l,d,u,f,h,m,y,p,g,v,b,w,_,S,I=t.btoa,x=t.atob,k=e.bd,C=e.pd,D=e.vm,P=e.hs,T=e.dt,N=e.dm,E=["https://mlts.dynamsoft.com/","https://slts.dynamsoft.com/"],O=!1,M=Promise.resolve(),R=e.log&&((...t)=>{try{e.log.apply(null,t)}catch(e){setTimeout((()=>{throw e}),0)}})||(()=>{}),j=k&&R||(()=>{}),B=e=>e.join(""),A={a:[80,88,27,82,145,164,199,211],b:[187,87,89,128,150,44,190,213],c:[89,51,74,53,99,72,82,118],d:[99,181,118,158,215,103,76,117],e:[99,51,86,105,100,71,120,108],f:[97,87,49,119,98,51,74,48,83,50,86,53],g:[81,85,86,84,76,85,100,68,84,81,32,32],h:[90,87,53,106,99,110,108,119,100,65,32,32],i:[90,71,86,106,99,110,108,119,100,65,32,32],j:[97,88,89,32],k:[29,83,122,137,5,180,157,114],l:[100,71,70,110,84,71,86,117,90,51,82,111]},U=()=>t[B(A.c)][B(A.e)][B(A.f)]("raw",new Uint8Array(A.a.concat(A.b,A.d,A.k)),B(A.g),!0,[B(A.h),B(A.i)]),F=async e=>{if(t[B(A.c)]&&t[B(A.c)][B(A.e)]&&t[B(A.c)][B(A.e)][B(A.f)]){let r=x(e),n=new Uint8Array(r.length);for(let e=0;e<r.length;++e)n[e]=r.charCodeAt(e);let o=n.subarray(0,12),i=n.subarray(o.length);S||(S=await U());let a=await t[B(A.c)][B(A.e)][B(A.i)]({name:B(A.g),[B(A.j)]:o,[B(A.l)]:128},S,i);return String.fromCharCode.apply(null,new Uint8Array(a))}},W=e=>x(x(e.replace(/\n/g,"+").replace(/\s/g,"=")).substring(1)),H=e=>I(String.fromCharCode(97+25*Math.random())+I(e)).replace(/\+/g,"\n").replace(/=/g," "),J=()=>{if(t.crypto){let e=new Uint8Array(36);t.crypto.getRandomValues(e);let r="";for(let t=0;t<36;++t){let n=e[t]%36;r+=n<10?n:String.fromCharCode(n+87)}return r}return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(e){var t=16*Math.random()|0;return("x"==e?t:3&t|8).toString(16)}))};const L="Failed to connect to the Dynamsoft License Server: ",$=" Check your Internet connection or contact Dynamsoft Support (support@dynamsoft.com) to acquire an offline license.",z={dlsErrorAndCacheExpire:L+"The cached license has expired. Please get connected to the network as soon as possible or contact the site administrator for more information.",publicTrialNetworkTimeout:L+"network timed out."+$,networkTimeout:L+"network timed out. Check your Internet connection or contact the site administrator for more information.",publicTrialFailConnect:L+"network connection error."+$,failConnect:L+"network connection error. Check your Internet connection or contact the site administrator for more information.",checkLocalTime:"Your system date and time appear to have been changed, causing the license to fail. Please correct the system date and time, then try again.",idbTimeout:"Failed to open indexedDB: Timeout.",dlsOfflineLicenseExpired:"The DLS2 Offline license has expired. Please contact the site administrator for more information."};let V,G,K,X,Y=async()=>{if(V)return V;V=new q,await(async()=>{m||(m=Z)})(),await Promise.race([(async()=>{let e=await m.createInstance({name:"dynamjssdkhello"});await e.setItem("dynamjssdkhello","available")})(),new Promise(((e,t)=>{setTimeout((()=>t(new Error(z.idbTimeout))),5e3)}))]),p=await m.createInstance({name:"dynamdlsinfo"}),g=I(I("v2")+String.fromCharCode(N.charCodeAt(N.length/2)+1)+I(N));try{let e=await p.getItem(g),t=null;self.indexedDB&&(t=await self.indexedDB.databases());let r=t&&t.some((e=>{if(e)return"dynamltsinfo"===e.name}));if(!e&&r){let t=await m.createInstance({name:"dynamltsinfo"});e=await t.getItem(g),e&&await p.setItem(g,e)}e&&([o,f]=JSON.parse(await W(e)))}catch(e){}try{null==o&&(o=J(),p.setItem(g,await H(JSON.stringify([o,null]))))}catch(e){}V.resolve()},Q=async()=>{v=I(String.fromCharCode(P.charCodeAt(0)+10)+I(C)+I(P)+D+I(""+T)),y=await m.createInstance({name:"dynamdlsuns"+I(I("v2"))+I(String.fromCharCode(P.charCodeAt(0)+10)+I(C)+I(P)+D+I(""+T))});try{n=await p.getItem(v)}catch(e){}B=e=>x(String.fromCharCode.apply(null,e).replace(/\n/g,"+").replace(/\s/g,"="))},ee=async e=>{if(K=Date.now(),G)return G;G=new q;try{let t={pd:C,vm:D,v:r,dt:T||"browser",ed:"javascript",cu:o,ad:N,os:i,fn:a};d&&(t.rmk=d),P&&(-1!=P.indexOf("-")?t.hs=P:t.og=P);let s={};if(f){let e=await p.getItem(g);e&&([o,f]=JSON.parse(await W(e))),s["lts-time"]=f}l&&(t.sp=l);let h=await Promise.race([(async()=>{let r,i=(new Date).kUtilFormat("yyyy-MM-ddTHH:mm:ss.SSSZ");f&&(p.setItem(g,await H(JSON.stringify([o,i]))),f=i);let a="auth/?ext="+encodeURIComponent(I(JSON.stringify(t)));u&&(a+="&"+encodeURIComponent(u));let l,d=!1,h=!1,m=async e=>{if(e&&!e.ok)try{let t=await e.text();if(t){let e=JSON.parse(t);e.errorCode&&(l=e,e.errorCode>100&&e.errorCode<200&&(n=null,d=!0,h=!0))}}catch(e){}};try{r=await Promise.race([fetch(E[0]+a,{headers:s,cache:e?"reload":"default",mode:"cors"}),new Promise(((e,t)=>setTimeout(t,1e4)))]),await m(r)}catch(e){}if(!(n||r&&r.ok||d))try{r=await Promise.race([fetch(E[1]+a,{headers:s,mode:"cors"}),new Promise(((e,t)=>setTimeout(t,3e4)))])}catch(e){}if(!(n||r&&r.ok||d))try{r=await Promise.race([fetch(E[0]+a,{headers:s,mode:"cors"}),new Promise(((e,t)=>setTimeout(t,3e4)))]),await m(r)}catch(e){}l&&151==l.errorCode&&(p.removeItem(g),p.removeItem(v),o=J(),t.cu=o,f=void 0,a="auth/?ext="+encodeURIComponent(I(JSON.stringify(t))),r=await Promise.race([fetch(E[0]+a,{headers:s,mode:"cors"}),new Promise(((e,t)=>setTimeout(t,3e4)))]),await m(r)),(()=>{if(!r||!r.ok){let e;h&&p.setItem(v,""),l?111==l.errorCode?e=l.message:(e=l.message.trim(),e.endsWith(".")||(e+="."),e=c?`An error occurred during authorization: ${e} [Contact Dynamsoft](https://www.dynamsoft.com/company/contact/) for more information.`:`An error occurred during authorization: ${e} Contact the site administrator for more information.`):e=c?z.publicTrialFailConnect:z.failConnect;let t=Error(e);throw l&&l.errorCode&&(t.ltsErrorCode=l.errorCode),t}})();let y=await r.text();try{f||(p.setItem(g,await H(JSON.stringify([o,i]))),f=i),p.setItem(v,y)}catch(e){}return y})(),new Promise(((e,t)=>{let r;r=c?z.publicTrialNetworkTimeout:z.networkTimeout,setTimeout((()=>t(new Error(r))),n?3e3:15e3)}))]);n=h}catch(e){k&&console.error(e),h=e}G.resolve(),G=null},te=async()=>{X||(X=(async()=>{if(j(o),!n){if(!O)throw R(h.message),h;return}let e={dm:N};k&&(e.bd=!0),e.brtk=!0,e.ls=E[0],P&&(-1!=P.indexOf("-")?e.hs=P:e.og=P),e.cu=o,a&&(e.fn=a),C&&(e.pd=C),r&&(e.v=r),T&&(e.dt=T),i&&(e.os=i),d&&(e.rmk=d),j(n);try{let t=JSON.parse(await F(n));t.pv&&(e.pv=JSON.stringify(t.pv)),t.ba&&(e.ba=t.ba),t.usu&&(e.usu=t.usu),t.trial&&(e.trial=t.trial),t.its&&(e.its=t.its),1==e.trial&&t.msg?e.msg=t.msg:h?e.msg=h.message||h:t.msg&&(e.msg=t.msg),e.ar=t.in,e.bafc=!!h}catch(e){}j(e);try{await b(e)}catch(e){j("error updl")}await re(),O||(O=!0),X=null})()),await X},re=async()=>{let e=(new Date).kUtilFormat("yyyy-MM-ddTHH:mm:ss.SSSZ"),t=await _();if(j(t),t&&t<e)throw h?new Error(z.dlsErrorAndCacheExpire):new Error(z.checkLocalTime)};const ne=new q;let oe=null,ie=async(e,t)=>(M=M.then((async()=>{try{let r=await y.keys();if(t||(ne.isFulfilled?e&&(r=r.filter((t=>t<e))):e&&r.includes(e)?r=[e]:(r=[],j("Unexpected null key"))),!r.length)return;for(let e=0;e<r.length/1e3;++e){let t=r.slice(1e3*e,1e3*(e+1)),n=[];for(let e=0;e<t.length;++e)n.push(await y.getItem(t[e]));f=(new Date).kUtilFormat("yyyy-MM-ddTHH:mm:ss.SSSZ");{let e=await p.getItem(g);e&&([o]=JSON.parse(await W(e))),p.setItem(g,await H(JSON.stringify([o,f])))}try{let e,r,o=E[0]+"verify/v2";f&&(o+="?ltstime="+encodeURIComponent(f));try{e=fetch(o,{method:"POST",body:n.join(";"),keepalive:!0})}finally{!ne.isFulfilled&&s&&ne.resolve()}try{r=await e}finally{ne.isFulfilled||ne.resolve()}if(!r.ok)throw new Error("verify failed. Status Code: "+r.status);for(let e=0;e<t.length;++e)await y.removeItem(t[e])}catch(e){throw ne.isFulfilled||ne.resolve(),e}}}catch(e){}})),await M);return{i:async e=>{C=e.pd,r=e.v,D=r.split(".")[0],e.dt&&(T=e.dt),P=e.l||"",i="string"!=typeof e.os?JSON.stringify(e.os):e.os,a=e.fn,"string"==typeof a&&(a=a.substring(0,255)),e.ls&&e.ls.length&&(E=e.ls,1==E.length&&E.push(E[0])),c=!P||"200001"===P||P.startsWith("200001-"),l=e.sp,d=e.rmk,"string"==typeof d&&(d=d.substring(0,255)),e.cv&&(u=""+e.cv),b=e.updl,w=e.mnet,_=e.mxet,await Y(),await Q(),await ee(),await te(),(!h||h.ltsErrorCode>=102&&h.ltsErrorCode<=120)&&ie(null,!0)},i2:async({updl:e,mxet:t,strDLC2:r})=>{b=e,_=t,await Y(),B=e=>x(String.fromCharCode.apply(null,e).replace(/\n/g,"+").replace(/\s/g,"="));let i={pk:r,dm:N};k&&(i.bd=!0),i.cu=o;try{n=r.substring(4);let e=JSON.parse(await F(n));e.pv&&(i.pv=JSON.stringify(e.pv)),e.ba&&(i.ba=e.ba),i.ar=e.in}catch(e){}j(i);try{await b(i)}catch(e){j("error updl")}let a=(new Date).kUtilFormat("yyyy-MM-ddTHH:mm:ss.SSSZ"),s=await _();if(s&&s<a)throw new Error(z.dlsOfflineLicenseExpired)},ih:Q,c:async()=>{let e=new Date;if(e.getTime()<K+36e4)return;let t=e.kUtilFormat("yyyy-MM-ddTHH:mm:ss.SSSZ"),r=await w(),n=await _();if(n&&n<t)await ee(!0),await te();else if(r&&r<t){let t=new Date(e.getTime());t.setMinutes(e.getMinutes()-6);let r=t.kUtilFormat("yyyy-MM-ddTHH:mm:ss.SSSZ");f<r&&ee().then((()=>te()))}},s:async(e,r,n,o)=>{try{let e;e=r.startsWith("{")&&r.endsWith("}")?await(async e=>{if(t[B(A.c)]&&t[B(A.c)][B(A.e)]&&t[B(A.c)][B(A.e)][B(A.f)]){let r=new Uint8Array(e.length);for(let t=0;t<e.length;++t)r[t]=e.charCodeAt(t);let n=t.crypto.getRandomValues(new Uint8Array(12));S||(S=await U());let o=await t[B(A.c)][B(A.e)][B(A.h)]({name:B(A.g),[B(A.j)]:n,[B(A.l)]:128},S,r),i=new Uint8Array(o),a=new Uint8Array(n.length+i.length);return a.set(n),a.set(i,n.length),I(String.fromCharCode.apply(null,a))}})(r):r,e?(j("bs "+n),await y.setItem(n,e),j("ss "+n)):j("ept ecpt")}catch(e){}o&&(j("bd "+n),await ie(n,2==o),j("sd "+n)),oe&&clearTimeout(oe),oe=setTimeout((async()=>{await ie()}),36e4)},p:ne,u:async()=>(await Y(),o),ar:()=>n,pt:()=>c,ae:()=>h}};const Y=self;let Q,ee,te,re;Y.licenseWorkerVersion="3.4.31";const ne=async e=>{await waitAsyncDependency("core"),await waitAsyncDependency("license"),Q=e.trial,ee=e.msg,ep(),re=JSON.parse(UTF8ToString(wasmImports.emscripten_bind_CoreWasm_static_init_1(es(JSON.stringify(e)))))},oe=()=>{let e=Module.getMinExpireTime;return e?e():null},ie=()=>{let e=Module.getMaxExpireTime;return e?e():null};Y.checkAndReauth=async()=>{},Object.assign(mapController,{license_dynamsoft:async(e,t)=>{try{let r,n=e.l,o=e.brtk,i=async()=>{te=te||X({dm:strDomain,log,bd:bDebug}),Y.scsd=te.s,e.pd="",e.v="0."+e.v,e.updl=ne,e.mnet=oe,e.mxet=ie,await te.i(e)},a=async()=>{if(n.startsWith("DLC2"))te=te||X({dm:strDomain,log,bd:bDebug}),await te.i2({updl:ne,mxet:ie,strDLC2:n});else{let e={pk:n,dm:strDomain};bDebug&&(e.bd=!0),await ne(e)}};o?await i():await a(),handleTaskRes(t,{trial:Q,ltsErrorCode:r,message:ee,initLicenseInfo:re,bSupportDce4Module:wasmImports.emscripten_bind_CoreWasm_static_GetIsSupportDceModule_0(),bSupportIRTModule:wasmImports.emscripten_bind_CoreWasm_static_GetIsSupportIRTModule_0()})}catch(e){handleTaskErr(t,e)}},license_getDeviceUUID:async(e,t)=>{try{te=te||X({dm:strDomain,log,bd:bDebug});let e=await te.u();handleTaskRes(t,{uuid:e})}catch(e){handleTaskErr(t,e)}},license_getAR:async(e,t)=>{try{if(te){let e={u:await te.u(),pt:te.pt()},r=te.ar();r&&(e.ar=r);let n=te.ae();n&&(e.lem=n.message,e.lec=n.ltsErrorCode),handleTaskRes(t,e)}else handleTaskRes(t,null)}catch(e){handleTaskErr(t,e)}}})}();
