<!DOCTYPE html>
<html lang="pt-BR">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Leitor de QR Code</title>
  <script src="https://unpkg.com/html5-qrcode"></script>
  <style>
    body {
      font-family: Arial, sans-serif;
      padding: 1rem;
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    h1 {
      margin-bottom: 1rem;
      text-align: center;
    }

    #reader {
      width: 100%;
      max-width: 400px;
      aspect-ratio: 1/1;
      margin-bottom: 1rem;
    }

    #result {
      font-size: 1.2rem;
      color: green;
      text-align: center;
      word-break: break-word;
      margin-bottom: 1rem;
    }

    select, button {
      padding: 10px;
      font-size: 1rem;
      margin: 0.5rem;
    }
  </style>
</head>
<body>

  <h1>Leitor de QR Code</h1>

  <select id="cameraSelect"></select>

  <div id="reader"></div>

  <div id="result">Aguardando leitura...</div>

  <button id="startBtn">Iniciar Leitor</button>
  <button id="stopBtn" style="display: none;">Parar Leitor</button>

  <script>
    const resultDiv = document.getElementById("result");
    const startBtn = document.getElementById("startBtn");
    const stopBtn = document.getElementById("stopBtn");
    const cameraSelect = document.getElementById("cameraSelect");
    const html5QrCode = new Html5Qrcode("reader");
    const config = { fps: 10, qrbox: 250 };
    let isRunning = false;

    async function listarCameras() {
      try {
        const devices = await Html5Qrcode.getCameras();
        cameraSelect.innerHTML = "";

        if (!devices || devices.length === 0) {
          resultDiv.textContent = "Nenhuma câmera encontrada.";
          return;
        }

        devices.forEach((device, index) => {
          const option = document.createElement("option");
          option.value = device.id;
          option.text = device.label || `Câmera ${index + 1}`;
          cameraSelect.appendChild(option);
        });
      } catch (err) {
        resultDiv.textContent = "Erro ao listar câmeras: " + err;
      }
    }

    async function startScanner() {
      const cameraId = cameraSelect.value;
      if (!cameraId) {
        resultDiv.textContent = "Selecione uma câmera.";
        return;
      }

      try {
        await html5QrCode.start(
          { deviceId: { exact: cameraId } },
          config,
          qrCodeMessage => {
            resultDiv.textContent = "Código lido: " + qrCodeMessage;
            stopScanner(); // remove se quiser leitura contínua
          },
          error => {
            // silencioso: erros de leitura comum
          }
        );

        isRunning = true;
        startBtn.style.display = "none";
        stopBtn.style.display = "inline-block";
        resultDiv.textContent = "Escaneando...";

      } catch (err) {
        resultDiv.textContent = "Erro ao iniciar scanner: " + err;
      }
    }

    async function stopScanner() {
      if (!isRunning) return;
      await html5QrCode.stop();
      isRunning = false;
      startBtn.style.display = "inline-block";
      stopBtn.style.display = "none";
      resultDiv.textContent += "\nScanner parado.";
    }

    // Eventos
    startBtn.addEventListener("click", startScanner);
    stopBtn.addEventListener("click", stopScanner);

    // Ao carregar, listar câmeras
    listarCameras();
  </script>

</body>
</html>
