/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft Capture Vision Router JS Edition
 * @website http://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version "2.4.33"
 * @fileoverview Dynamsoft JavaScript Library for Capture Vision
 * More info on cvr JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/capture-vision-router/capture-vision-router-module.html
 */
!function(){"use strict";
/*!
     * Dynamsoft JavaScript Library
     * @product Dynamsoft Core JS Edition
     * @website https://www.dynamsoft.com
     * @copyright Copyright 2024, Dynamsoft Corporation
     * @author Dynamsoft
     * @version 3.4.30
     * @fileoverview Dynamsoft JavaScript Library for Core
     * More info on Dynamsoft Core JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/core/core-module.html
     */var _,e,E,t;"function"==typeof SuppressedError&&SuppressedError,(t=_||(_={}))[t.BOPM_BLOCK=0]="BOPM_BLOCK",t[t.BOPM_UPDATE=1]="BOPM_UPDATE",function(_){_[_.CCUT_AUTO=0]="CCUT_AUTO",_[_.CCUT_FULL_CHANNEL=1]="CCUT_FULL_CHANNEL",_[_.CCUT_Y_CHANNEL_ONLY=2]="CCUT_Y_CHANNEL_ONLY",_[_.CCUT_RGB_R_CHANNEL_ONLY=3]="CCUT_RGB_R_CHANNEL_ONLY",_[_.CCUT_RGB_G_CHANNEL_ONLY=4]="CCUT_RGB_G_CHANNEL_ONLY",_[_.CCUT_RGB_B_CHANNEL_ONLY=5]="CCUT_RGB_B_CHANNEL_ONLY"}(e||(e={})),function(_){_[_.IPF_BINARY=0]="IPF_BINARY",_[_.IPF_BINARYINVERTED=1]="IPF_BINARYINVERTED",_[_.IPF_GRAYSCALED=2]="IPF_GRAYSCALED",_[_.IPF_NV21=3]="IPF_NV21",_[_.IPF_RGB_565=4]="IPF_RGB_565",_[_.IPF_RGB_555=5]="IPF_RGB_555",_[_.IPF_RGB_888=6]="IPF_RGB_888",_[_.IPF_ARGB_8888=7]="IPF_ARGB_8888",_[_.IPF_RGB_161616=8]="IPF_RGB_161616",_[_.IPF_ARGB_16161616=9]="IPF_ARGB_16161616",_[_.IPF_ABGR_8888=10]="IPF_ABGR_8888",_[_.IPF_ABGR_16161616=11]="IPF_ABGR_16161616",_[_.IPF_BGR_888=12]="IPF_BGR_888",_[_.IPF_BINARY_8=13]="IPF_BINARY_8",_[_.IPF_NV12=14]="IPF_NV12",_[_.IPF_BINARY_8_INVERTED=15]="IPF_BINARY_8_INVERTED"}(E||(E={}));const s=_=>"number"==typeof _&&!Number.isNaN(_),I=_=>null!==_&&"object"==typeof _&&!Array.isArray(_),r=_=>!(!(_=>!(!I(_)||!s(_.width)||_.width<=0||!s(_.height)||_.height<=0||!s(_.stride)||_.stride<=0||!("format"in _)||"tag"in _&&!n(_.tag)))(_)||!s(_.bytes.length)&&!s(_.bytes.ptr)),n=_=>null===_||!!I(_)&&!!s(_.imageId)&&"type"in _,C="undefined"==typeof self,T="function"==typeof importScripts,a=(()=>{if(!T){if(!C&&document.currentScript){let _=document.currentScript.src,e=_.indexOf("?");if(-1!=e)_=_.substring(0,e);else{let e=_.indexOf("#");-1!=e&&(_=_.substring(0,e))}return _.substring(0,_.lastIndexOf("/")+1)}return"./"}})();let A,i,R,N,D;async function O(_,e){return await new Promise(((E,t)=>{let s=new XMLHttpRequest;s.open("GET",_,!0),s.responseType=e,s.send(),s.onloadend=async()=>{s.status<200||s.status>=300?t(_+" "+s.status):E(s.response)},s.onerror=()=>{t(new Error("Network Error: "+s.statusText))}}))}var L,o,S,c,l,m,p,u,d;"undefined"!=typeof navigator&&(A=navigator,i=A.userAgent,R=A.platform,N=A.mediaDevices),function(){if(!C){const _={Edge:{search:"Edg",verSearch:"Edg"},OPR:null,Chrome:null,Safari:{str:A.vendor,search:"Apple",verSearch:["Version","iPhone OS","CPU OS"]},Firefox:null,Explorer:{search:"MSIE",verSearch:"MSIE"}},e={HarmonyOS:null,Android:null,iPhone:null,iPad:null,Windows:{str:R,search:"Win"},Mac:{str:R},Linux:{str:R}};let E="unknownBrowser",t=0,s="unknownOS";for(let e in _){const s=_[e]||{};let I=s.str||i,r=s.search||e,n=s.verStr||i,C=s.verSearch||e;if(C instanceof Array||(C=[C]),-1!=I.indexOf(r)){E=e;for(let _ of C){let e=n.indexOf(_);if(-1!=e){t=parseFloat(n.substring(e+_.length+1));break}}break}}for(let _ in e){const E=e[_]||{};let t=E.str||i,I=E.search||_;if(-1!=t.indexOf(I)){s=_;break}}"Linux"==s&&-1!=i.indexOf("Windows NT")&&(s="HarmonyOS"),D={browser:E,version:t,OS:s}}C&&(D={browser:"ssr",version:0,OS:"ssr"})}(),N&&N.getUserMedia,"Chrome"===D.browser&&D.version>66||"Safari"===D.browser&&D.version>13||"OPR"===D.browser&&D.version>43||"Edge"===D.browser&&D.version,(_=>{if(null==_&&(_="./"),C||T);else{let e=document.createElement("a");e.href=_,_=e.href}_.endsWith("/")||(_+="/")})(a+"../../dynamsoft-capture-vision-std@1.4.10/dist/"),function(_){_[_.CRIT_ORIGINAL_IMAGE=1]="CRIT_ORIGINAL_IMAGE",_[_.CRIT_BARCODE=2]="CRIT_BARCODE",_[_.CRIT_TEXT_LINE=4]="CRIT_TEXT_LINE",_[_.CRIT_DETECTED_QUAD=8]="CRIT_DETECTED_QUAD",_[_.CRIT_NORMALIZED_IMAGE=16]="CRIT_NORMALIZED_IMAGE",_[_.CRIT_PARSED_RESULT=32]="CRIT_PARSED_RESULT"}(L||(L={})),function(_){_[_.CT_NORMAL_INTERSECTED=0]="CT_NORMAL_INTERSECTED",_[_.CT_T_INTERSECTED=1]="CT_T_INTERSECTED",_[_.CT_CROSS_INTERSECTED=2]="CT_CROSS_INTERSECTED",_[_.CT_NOT_INTERSECTED=3]="CT_NOT_INTERSECTED"}(o||(o={})),function(_){_[_.EC_OK=0]="EC_OK",_[_.EC_UNKNOWN=-1e4]="EC_UNKNOWN",_[_.EC_NO_MEMORY=-10001]="EC_NO_MEMORY",_[_.EC_NULL_POINTER=-10002]="EC_NULL_POINTER",_[_.EC_LICENSE_INVALID=-10003]="EC_LICENSE_INVALID",_[_.EC_LICENSE_EXPIRED=-10004]="EC_LICENSE_EXPIRED",_[_.EC_FILE_NOT_FOUND=-10005]="EC_FILE_NOT_FOUND",_[_.EC_FILE_TYPE_NOT_SUPPORTED=-10006]="EC_FILE_TYPE_NOT_SUPPORTED",_[_.EC_BPP_NOT_SUPPORTED=-10007]="EC_BPP_NOT_SUPPORTED",_[_.EC_INDEX_INVALID=-10008]="EC_INDEX_INVALID",_[_.EC_CUSTOM_REGION_INVALID=-10010]="EC_CUSTOM_REGION_INVALID",_[_.EC_IMAGE_READ_FAILED=-10012]="EC_IMAGE_READ_FAILED",_[_.EC_TIFF_READ_FAILED=-10013]="EC_TIFF_READ_FAILED",_[_.EC_DIB_BUFFER_INVALID=-10018]="EC_DIB_BUFFER_INVALID",_[_.EC_PDF_READ_FAILED=-10021]="EC_PDF_READ_FAILED",_[_.EC_PDF_DLL_MISSING=-10022]="EC_PDF_DLL_MISSING",_[_.EC_PAGE_NUMBER_INVALID=-10023]="EC_PAGE_NUMBER_INVALID",_[_.EC_CUSTOM_SIZE_INVALID=-10024]="EC_CUSTOM_SIZE_INVALID",_[_.EC_TIMEOUT=-10026]="EC_TIMEOUT",_[_.EC_JSON_PARSE_FAILED=-10030]="EC_JSON_PARSE_FAILED",_[_.EC_JSON_TYPE_INVALID=-10031]="EC_JSON_TYPE_INVALID",_[_.EC_JSON_KEY_INVALID=-10032]="EC_JSON_KEY_INVALID",_[_.EC_JSON_VALUE_INVALID=-10033]="EC_JSON_VALUE_INVALID",_[_.EC_JSON_NAME_KEY_MISSING=-10034]="EC_JSON_NAME_KEY_MISSING",_[_.EC_JSON_NAME_VALUE_DUPLICATED=-10035]="EC_JSON_NAME_VALUE_DUPLICATED",_[_.EC_TEMPLATE_NAME_INVALID=-10036]="EC_TEMPLATE_NAME_INVALID",_[_.EC_JSON_NAME_REFERENCE_INVALID=-10037]="EC_JSON_NAME_REFERENCE_INVALID",_[_.EC_PARAMETER_VALUE_INVALID=-10038]="EC_PARAMETER_VALUE_INVALID",_[_.EC_DOMAIN_NOT_MATCH=-10039]="EC_DOMAIN_NOT_MATCH",_[_.EC_RESERVED_INFO_NOT_MATCH=-10040]="EC_RESERVED_INFO_NOT_MATCH",_[_.EC_LICENSE_KEY_NOT_MATCH=-10043]="EC_LICENSE_KEY_NOT_MATCH",_[_.EC_REQUEST_FAILED=-10044]="EC_REQUEST_FAILED",_[_.EC_LICENSE_INIT_FAILED=-10045]="EC_LICENSE_INIT_FAILED",_[_.EC_SET_MODE_ARGUMENT_ERROR=-10051]="EC_SET_MODE_ARGUMENT_ERROR",_[_.EC_LICENSE_CONTENT_INVALID=-10052]="EC_LICENSE_CONTENT_INVALID",_[_.EC_LICENSE_KEY_INVALID=-10053]="EC_LICENSE_KEY_INVALID",_[_.EC_LICENSE_DEVICE_RUNS_OUT=-10054]="EC_LICENSE_DEVICE_RUNS_OUT",_[_.EC_GET_MODE_ARGUMENT_ERROR=-10055]="EC_GET_MODE_ARGUMENT_ERROR",_[_.EC_IRT_LICENSE_INVALID=-10056]="EC_IRT_LICENSE_INVALID",_[_.EC_FILE_SAVE_FAILED=-10058]="EC_FILE_SAVE_FAILED",_[_.EC_STAGE_TYPE_INVALID=-10059]="EC_STAGE_TYPE_INVALID",_[_.EC_IMAGE_ORIENTATION_INVALID=-10060]="EC_IMAGE_ORIENTATION_INVALID",_[_.EC_CONVERT_COMPLEX_TEMPLATE_ERROR=-10061]="EC_CONVERT_COMPLEX_TEMPLATE_ERROR",_[_.EC_CALL_REJECTED_WHEN_CAPTURING=-10062]="EC_CALL_REJECTED_WHEN_CAPTURING",_[_.EC_NO_IMAGE_SOURCE=-10063]="EC_NO_IMAGE_SOURCE",_[_.EC_READ_DIRECTORY_FAILED=-10064]="EC_READ_DIRECTORY_FAILED",_[_.EC_MODULE_NOT_FOUND=-10065]="EC_MODULE_NOT_FOUND",_[_.EC_MULTI_PAGES_NOT_SUPPORTED=-10066]="EC_MULTI_PAGES_NOT_SUPPORTED",_[_.EC_FILE_ALREADY_EXISTS=-10067]="EC_FILE_ALREADY_EXISTS",_[_.EC_CREATE_FILE_FAILED=-10068]="EC_CREATE_FILE_FAILED",_[_.EC_IMGAE_DATA_INVALID=-10069]="EC_IMGAE_DATA_INVALID",_[_.EC_IMAGE_SIZE_NOT_MATCH=-10070]="EC_IMAGE_SIZE_NOT_MATCH",_[_.EC_IMAGE_PIXEL_FORMAT_NOT_MATCH=-10071]="EC_IMAGE_PIXEL_FORMAT_NOT_MATCH",_[_.EC_SECTION_LEVEL_RESULT_IRREPLACEABLE=-10072]="EC_SECTION_LEVEL_RESULT_IRREPLACEABLE",_[_.EC_AXIS_DEFINITION_INCORRECT=-10073]="EC_AXIS_DEFINITION_INCORRECT",_[_.EC_RESULT_TYPE_MISMATCH_IRREPLACEABLE=-10074]="EC_RESULT_TYPE_MISMATCH_IRREPLACEABLE",_[_.EC_PDF_LIBRARY_LOAD_FAILED=-10075]="EC_PDF_LIBRARY_LOAD_FAILED",_[_.EC_NO_LICENSE=-2e4]="EC_NO_LICENSE",_[_.EC_HANDSHAKE_CODE_INVALID=-20001]="EC_HANDSHAKE_CODE_INVALID",_[_.EC_LICENSE_BUFFER_FAILED=-20002]="EC_LICENSE_BUFFER_FAILED",_[_.EC_LICENSE_SYNC_FAILED=-20003]="EC_LICENSE_SYNC_FAILED",_[_.EC_DEVICE_NOT_MATCH=-20004]="EC_DEVICE_NOT_MATCH",_[_.EC_BIND_DEVICE_FAILED=-20005]="EC_BIND_DEVICE_FAILED",_[_.EC_INSTANCE_COUNT_OVER_LIMIT=-20008]="EC_INSTANCE_COUNT_OVER_LIMIT",_[_.EC_LICENSE_INIT_SEQUENCE_FAILED=-20009]="EC_LICENSE_INIT_SEQUENCE_FAILED",_[_.EC_TRIAL_LICENSE=-20010]="EC_TRIAL_LICENSE",_[_.EC_FAILED_TO_REACH_DLS=-20200]="EC_FAILED_TO_REACH_DLS",_[_.EC_LICENSE_CACHE_USED=-20012]="EC_LICENSE_CACHE_USED",_[_.EC_BARCODE_FORMAT_INVALID=-30009]="EC_BARCODE_FORMAT_INVALID",_[_.EC_QR_LICENSE_INVALID=-30016]="EC_QR_LICENSE_INVALID",_[_.EC_1D_LICENSE_INVALID=-30017]="EC_1D_LICENSE_INVALID",_[_.EC_PDF417_LICENSE_INVALID=-30019]="EC_PDF417_LICENSE_INVALID",_[_.EC_DATAMATRIX_LICENSE_INVALID=-30020]="EC_DATAMATRIX_LICENSE_INVALID",_[_.EC_CUSTOM_MODULESIZE_INVALID=-30025]="EC_CUSTOM_MODULESIZE_INVALID",_[_.EC_AZTEC_LICENSE_INVALID=-30041]="EC_AZTEC_LICENSE_INVALID",_[_.EC_PATCHCODE_LICENSE_INVALID=-30046]="EC_PATCHCODE_LICENSE_INVALID",_[_.EC_POSTALCODE_LICENSE_INVALID=-30047]="EC_POSTALCODE_LICENSE_INVALID",_[_.EC_DPM_LICENSE_INVALID=-30048]="EC_DPM_LICENSE_INVALID",_[_.EC_FRAME_DECODING_THREAD_EXISTS=-30049]="EC_FRAME_DECODING_THREAD_EXISTS",_[_.EC_STOP_DECODING_THREAD_FAILED=-30050]="EC_STOP_DECODING_THREAD_FAILED",_[_.EC_MAXICODE_LICENSE_INVALID=-30057]="EC_MAXICODE_LICENSE_INVALID",_[_.EC_GS1_DATABAR_LICENSE_INVALID=-30058]="EC_GS1_DATABAR_LICENSE_INVALID",_[_.EC_GS1_COMPOSITE_LICENSE_INVALID=-30059]="EC_GS1_COMPOSITE_LICENSE_INVALID",_[_.EC_DOTCODE_LICENSE_INVALID=-30061]="EC_DOTCODE_LICENSE_INVALID",_[_.EC_PHARMACODE_LICENSE_INVALID=-30062]="EC_PHARMACODE_LICENSE_INVALID",_[_.EC_CHARACTER_MODEL_FILE_NOT_FOUND=-40100]="EC_CHARACTER_MODEL_FILE_NOT_FOUND",_[_.EC_TEXT_LINE_GROUP_LAYOUT_CONFLICT=-40101]="EC_TEXT_LINE_GROUP_LAYOUT_CONFLICT",_[_.EC_TEXT_LINE_GROUP_REGEX_CONFLICT=-40102]="EC_TEXT_LINE_GROUP_REGEX_CONFLICT",_[_.EC_QUADRILATERAL_INVALID=-50057]="EC_QUADRILATERAL_INVALID",_[_.EC_PANORAMA_LICENSE_INVALID=-70060]="EC_PANORAMA_LICENSE_INVALID",_[_.EC_RESOURCE_PATH_NOT_EXIST=-90001]="EC_RESOURCE_PATH_NOT_EXIST",_[_.EC_RESOURCE_LOAD_FAILED=-90002]="EC_RESOURCE_LOAD_FAILED",_[_.EC_CODE_SPECIFICATION_NOT_FOUND=-90003]="EC_CODE_SPECIFICATION_NOT_FOUND",_[_.EC_FULL_CODE_EMPTY=-90004]="EC_FULL_CODE_EMPTY",_[_.EC_FULL_CODE_PREPROCESS_FAILED=-90005]="EC_FULL_CODE_PREPROCESS_FAILED",_[_.EC_ZA_DL_LICENSE_INVALID=-90006]="EC_ZA_DL_LICENSE_INVALID",_[_.EC_AAMVA_DL_ID_LICENSE_INVALID=-90007]="EC_AAMVA_DL_ID_LICENSE_INVALID",_[_.EC_AADHAAR_LICENSE_INVALID=-90008]="EC_AADHAAR_LICENSE_INVALID",_[_.EC_MRTD_LICENSE_INVALID=-90009]="EC_MRTD_LICENSE_INVALID",_[_.EC_VIN_LICENSE_INVALID=-90010]="EC_VIN_LICENSE_INVALID",_[_.EC_CUSTOMIZED_CODE_TYPE_LICENSE_INVALID=-90011]="EC_CUSTOMIZED_CODE_TYPE_LICENSE_INVALID",_[_.EC_LICENSE_WARNING=-10076]="EC_LICENSE_WARNING",_[_.EC_BARCODE_READER_LICENSE_NOT_FOUND=-30063]="EC_BARCODE_READER_LICENSE_NOT_FOUND",_[_.EC_LABEL_RECOGNIZER_LICENSE_NOT_FOUND=-40103]="EC_LABEL_RECOGNIZER_LICENSE_NOT_FOUND",_[_.EC_DOCUMENT_NORMALIZER_LICENSE_NOT_FOUND=-50058]="EC_DOCUMENT_NORMALIZER_LICENSE_NOT_FOUND",_[_.EC_CODE_PARSER_LICENSE_NOT_FOUND=-90012]="EC_CODE_PARSER_LICENSE_NOT_FOUND"}(S||(S={})),function(_){_[_.GEM_SKIP=0]="GEM_SKIP",_[_.GEM_AUTO=1]="GEM_AUTO",_[_.GEM_GENERAL=2]="GEM_GENERAL",_[_.GEM_GRAY_EQUALIZE=4]="GEM_GRAY_EQUALIZE",_[_.GEM_GRAY_SMOOTH=8]="GEM_GRAY_SMOOTH",_[_.GEM_SHARPEN_SMOOTH=16]="GEM_SHARPEN_SMOOTH",_[_.GEM_REV=-2147483648]="GEM_REV"}(c||(c={})),function(_){_[_.GTM_SKIP=0]="GTM_SKIP",_[_.GTM_INVERTED=1]="GTM_INVERTED",_[_.GTM_ORIGINAL=2]="GTM_ORIGINAL",_[_.GTM_AUTO=4]="GTM_AUTO",_[_.GTM_REV=-2147483648]="GTM_REV"}(l||(l={})),function(_){_[_.ITT_FILE_IMAGE=0]="ITT_FILE_IMAGE",_[_.ITT_VIDEO_FRAME=1]="ITT_VIDEO_FRAME"}(m||(m={})),function(_){_[_.PDFRM_VECTOR=1]="PDFRM_VECTOR",_[_.PDFRM_RASTER=2]="PDFRM_RASTER",_[_.PDFRM_REV=-2147483648]="PDFRM_REV"}(p||(p={})),function(_){_[_.RDS_RASTERIZED_PAGES=0]="RDS_RASTERIZED_PAGES",_[_.RDS_EXTRACTED_IMAGES=1]="RDS_EXTRACTED_IMAGES"}(u||(u={})),function(_){_[_.CVS_NOT_VERIFIED=0]="CVS_NOT_VERIFIED",_[_.CVS_PASSED=1]="CVS_PASSED",_[_.CVS_FAILED=2]="CVS_FAILED"}(d||(d={}));const U={IRUT_NULL:BigInt(0),IRUT_COLOUR_IMAGE:BigInt(1),IRUT_SCALED_DOWN_COLOUR_IMAGE:BigInt(2),IRUT_GRAYSCALE_IMAGE:BigInt(4),IRUT_TRANSOFORMED_GRAYSCALE_IMAGE:BigInt(8),IRUT_ENHANCED_GRAYSCALE_IMAGE:BigInt(16),IRUT_PREDETECTED_REGIONS:BigInt(32),IRUT_BINARY_IMAGE:BigInt(64),IRUT_TEXTURE_DETECTION_RESULT:BigInt(128),IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE:BigInt(256),IRUT_TEXTURE_REMOVED_BINARY_IMAGE:BigInt(512),IRUT_CONTOURS:BigInt(1024),IRUT_LINE_SEGMENTS:BigInt(2048),IRUT_TEXT_ZONES:BigInt(4096),IRUT_TEXT_REMOVED_BINARY_IMAGE:BigInt(8192),IRUT_CANDIDATE_BARCODE_ZONES:BigInt(16384),IRUT_LOCALIZED_BARCODES:BigInt(32768),IRUT_SCALED_UP_BARCODE_IMAGE:BigInt(65536),IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE:BigInt(1<<17),IRUT_COMPLEMENTED_BARCODE_IMAGE:BigInt(1<<18),IRUT_DECODED_BARCODES:BigInt(1<<19),IRUT_LONG_LINES:BigInt(1<<20),IRUT_CORNERS:BigInt(1<<21),IRUT_CANDIDATE_QUAD_EDGES:BigInt(1<<22),IRUT_DETECTED_QUADS:BigInt(1<<23),IRUT_LOCALIZED_TEXT_LINES:BigInt(1<<24),IRUT_RECOGNIZED_TEXT_LINES:BigInt(1<<25),IRUT_NORMALIZED_IMAGES:BigInt(1<<26),IRUT_SHORT_LINES:BigInt(1<<27),IRUT_RAW_TEXT_LINES:BigInt(1<<28),IRUT_LOGIC_LINES:BigInt(1<<29),IRUT_ALL:BigInt("0xFFFFFFFFFFFFFFFF")};var M,g;function F(_,e){for(let E of _)if(E.result){if([U.IRUT_BINARY_IMAGE,U.IRUT_COLOUR_IMAGE,U.IRUT_COMPLEMENTED_BARCODE_IMAGE,U.IRUT_ENHANCED_GRAYSCALE_IMAGE,U.IRUT_GRAYSCALE_IMAGE,U.IRUT_SCALED_DOWN_COLOUR_IMAGE,U.IRUT_SCALED_UP_BARCODE_IMAGE,U.IRUT_TEXTURE_REMOVED_BINARY_IMAGE,U.IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE,U.IRUT_TEXT_REMOVED_BINARY_IMAGE,U.IRUT_TRANSOFORMED_GRAYSCALE_IMAGE].includes(BigInt(E.result.unitType))){let _=E.result.imageData.bytes;_&&(_=new Uint8Array(new Uint8Array(e.buffer,_.ptr,_.length)),E.result.imageData.bytes=_)}else if([U.IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE].includes(BigInt(E.result.unitType))){let _=E.result.deformationResistedBarcode.imageData.bytes;_&&(_=new Uint8Array(new Uint8Array(e.buffer,_.ptr,_.length)),E.result.deformationResistedBarcode.imageData.bytes=_)}else if([U.IRUT_CONTOURS].includes(BigInt(E.result.unitType))){let _=E.result.contours,t=E.result.contoursOffset;if(_&&t){_=new Uint8Array(new Uint8Array(e.buffer,_.ptr,_.length)),t=new Uint8Array(new Uint8Array(e.buffer,t.ptr,t.length));const s=new DataView(_.buffer),I=[];for(let e=0;e<_.length;e+=4)I.push(s.getInt32(e,!0));const r=new DataView(t.buffer),n=[0];for(let _=0;_<t.length;_+=4)n.push(r.getInt32(_,!0));const C=[];for(let _=0;_<n.length-1;_++){const e={points:[]};for(let E=n[_];E<n[_+1]-1;E+=2)e.points.push({x:I[E],y:I[E+1]});C.push(e)}E.result.contours=C,delete E.result.contoursOffset}}else if([U.IRUT_LINE_SEGMENTS].includes(BigInt(E.result.unitType))){let _=E.result.lineSegments;if(_){_=new Uint8Array(new Uint8Array(e.buffer,_.ptr,_.length));const t=new DataView(_.buffer),s=[];for(let e=0;e<_.length;e+=4)s.push(t.getInt32(e,!0));const I=[];for(let _=0;_<s.length;_+=4){const e={startPoint:{x:s[_],y:s[_+1]},endPoint:{x:s[_+2],y:s[_+3]}};I.push(e)}E.result.lineSegments=I}}else if([U.IRUT_LOGIC_LINES].includes(E.result.unitType)){let _=E.result.logicLines;if(_){_=new Uint8Array(new Uint8Array(e.buffer,_.ptr,_.length));const t=new DataView(_.buffer),s=[];for(let e=0;e<_.length;e+=4)s.push(t.getInt32(e,!0));const I=[];for(let _=0;_<s.length;_+=4){const e={startPoint:{x:s[_],y:s[_+1]},endPoint:{x:s[_+2],y:s[_+3]}};I.push(e)}E.result.logicLines=I}}else if([U.IRUT_SHORT_LINES].includes(BigInt(E.result.unitType))){let _=E.result.shortLines;if(_){_=new Uint8Array(new Uint8Array(e.buffer,_.ptr,_.length));const t=new DataView(_.buffer),s=[];for(let e=0;e<_.length;e+=4)s.push(t.getInt32(e,!0));const I=[];for(let _=0;_<s.length;_+=4){const e={startPoint:{x:s[_],y:s[_+1]},endPoint:{x:s[_+2],y:s[_+3]}};I.push(e)}E.result.shortLines=I}}else if([U.IRUT_CANDIDATE_QUAD_EDGES].includes(BigInt(E.result.unitType))){let _=E.result.candidateQuadEdges;if(_){_=new Uint8Array(new Uint8Array(e.buffer,_.ptr,_.length));const t=new DataView(_.buffer),s=[];for(let e=0;e<_.length;e+=4)s.push(t.getInt32(e,!0));const I=[];for(let _=0;_<s.length;_+=22){const e={startCorner:{intersection:{x:s[_],y:s[_+1]},line1:{startPoint:{x:s[_+2],y:s[_+3]},endPoint:{x:s[_+4],y:s[_+5]}},line2:{startPoint:{x:s[_+6],y:s[_+7]},endPoint:{x:s[_+8],y:s[_+9]}},type:s[_+10]},endCorner:{intersection:{x:s[_+11],y:s[_+12]},line1:{startPoint:{x:s[_+13],y:s[_+14]},endPoint:{x:s[_+15],y:s[_+16]}},line2:{startPoint:{x:s[_+17],y:s[_+18]},endPoint:{x:s[_+19],y:s[_+20]}},type:s[_+21]}};I.push(e)}E.result.candidateQuadEdges=I}}else if([U.IRUT_CORNERS].includes(BigInt(E.result.unitType))){let _=E.result.corners;if(_){_=new Uint8Array(new Uint8Array(e.buffer,_.ptr,_.length));const t=new DataView(_.buffer),s=[];for(let e=0;e<_.length;e+=4)s.push(t.getInt32(e,!0));const I=[];for(let _=0;_<s.length;_+=11){const e={intersection:{x:s[_],y:s[_+1]},line1:{startPoint:{x:s[_+2],y:s[_+3]},endPoint:{x:s[_+4],y:s[_+5]}},line2:{startPoint:{x:s[_+6],y:s[_+7]},endPoint:{x:s[_+8],y:s[_+9]}},type:s[_+10]};I.push(e)}E.result.corners=I}}else if([U.IRUT_NORMALIZED_IMAGES].includes(BigInt(E.result.unitType)))for(let _ of E.result.normalizedImages){let E=_.imageData.bytes;E&&(E=new Uint8Array(new Uint8Array(e.buffer,E.ptr,E.length)),_.imageData.bytes=E)}}else if(E.intermediateResultUnits)for(let _ of E.intermediateResultUnits)if(_.unitType===U.IRUT_NORMALIZED_IMAGES)for(let E of _.normalizedImages){let _=E.imageData.bytes;_&&(_=new Uint8Array(new Uint8Array(e.buffer,_.ptr,_.length)),E.imageData.bytes=_)}}!function(_){_[_.ROET_PREDETECTED_REGION=0]="ROET_PREDETECTED_REGION",_[_.ROET_LOCALIZED_BARCODE=1]="ROET_LOCALIZED_BARCODE",_[_.ROET_DECODED_BARCODE=2]="ROET_DECODED_BARCODE",_[_.ROET_LOCALIZED_TEXT_LINE=3]="ROET_LOCALIZED_TEXT_LINE",_[_.ROET_RECOGNIZED_TEXT_LINE=4]="ROET_RECOGNIZED_TEXT_LINE",_[_.ROET_DETECTED_QUAD=5]="ROET_DETECTED_QUAD",_[_.ROET_NORMALIZED_IMAGE=6]="ROET_NORMALIZED_IMAGE",_[_.ROET_SOURCE_IMAGE=7]="ROET_SOURCE_IMAGE",_[_.ROET_TARGET_ROI=8]="ROET_TARGET_ROI"}(M||(M={})),function(_){_[_.ST_NULL=0]="ST_NULL",_[_.ST_REGION_PREDETECTION=1]="ST_REGION_PREDETECTION",_[_.ST_BARCODE_LOCALIZATION=2]="ST_BARCODE_LOCALIZATION",_[_.ST_BARCODE_DECODING=3]="ST_BARCODE_DECODING",_[_.ST_TEXT_LINE_LOCALIZATION=4]="ST_TEXT_LINE_LOCALIZATION",_[_.ST_TEXT_LINE_RECOGNITION=5]="ST_TEXT_LINE_RECOGNITION",_[_.ST_DOCUMENT_DETECTION=6]="ST_DOCUMENT_DETECTION",_[_.ST_DOCUMENT_NORMALIZATION=7]="ST_DOCUMENT_NORMALIZATION"}(g||(g={}));let P,f,G,y=null,h=new Set;self.cvrWorkerVersion="2.4.33";const V=async(_,e)=>{ep();const E=JSON.parse(UTF8ToString(wasmImports.emscripten_bind_CvrWasm_ParseRequiredResources_1(_,es(e.templateName))));for(let _=0;_<E.models.length;_++)await checkAndAutoLoadCaffeModel(E.models[_],engineResourcePaths.dlrData);for(let _=0;_<E.specss.length;_++)await checkAndAutoLoadResourceBuffer(E.specss[_],engineResourcePaths.dcp+"specification/")};Object.assign(mapController,{cvr_createInstance:async(_,e)=>{try{let _=wasmImports.emscripten_bind_CvrWasm_CvrWasm_0();engineResourcePaths.dbr&&(P=await O(engineResourcePaths.dbr+"DBR-PresetTemplates.json","text"),ep(),wasmImports.emscripten_bind_CvrWasm_AppendParameterContent_1(_,es(P))),engineResourcePaths.dlr&&(f=await O(engineResourcePaths.dlr+"DLR-PresetTemplates.json","text"),ep(),wasmImports.emscripten_bind_CvrWasm_AppendParameterContent_1(_,es(f))),engineResourcePaths.ddn&&(G=await O(engineResourcePaths.ddn+"DDN-PresetTemplates.json","text"),ep(),wasmImports.emscripten_bind_CvrWasm_AppendParameterContent_1(_,es(G))),wasmImports.emscripten_bind_CvrWasm_InitParameter_0(_),ep();const E=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_OutputSettings_1(_,es("*")));let t=JSON.parse(UTF8ToString(wasmImports.emscripten_bind_CoreWasm_GetModuleVersion_0())).CVR;h.add(_),handleTaskRes(e,{instanceID:_,version:t,outputSettings:E})}catch(_){console.log(_),handleTaskErr(e,_)}},cvr_initSettings:async(_,e,E)=>{let t;try{const s=_.settings;ep(),t=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_InitSettings_1(E,es(s))),handleTaskRes(e,{success:!0,response:t})}catch(_){handleTaskErr(e,_)}},cvr_setCrrRegistry:async(_,e,E)=>{try{h.has(E)&&(ep(),wasmImports.emscripten_bind_CvrWasm_SetCrrRegistry_1(E,es(_.receiver))),handleTaskRes(e,{success:!0})}catch(_){handleTaskErr(e,_)}},cvr_startCapturing:async(_,e,E)=>{let t=!1;try{ep();const s=JSON.parse(UTF8ToString(wasmImports.emscripten_bind_CvrWasm_OutputSettings_1(E,es(_.templateName))));if(s&&0!==s.errorCode)throw new Error(s.errorString);t=1===JSON.parse(s.data).CaptureVisionTemplates[0].OutputOriginalImage,await V(E,_),handleTaskRes(e,{success:!0,isOutputOriginalImage:t})}catch(_){handleTaskErr(e,_)}},cvr_parseRequiredResources:async(_,e,E)=>{let t;try{ep(),t=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_ParseRequiredResources_1(E,es(_.templateName))),handleTaskRes(e,{success:!0,resources:t})}catch(_){handleTaskErr(e,_)}},cvr_clearVerifyList:(_,e,E)=>{try{wasmImports.emscripten_bind_CvrWasm_ClearVerifyList_0(E),handleTaskRes(e,{success:!0})}catch(_){handleTaskErr(e,_)}},cvr_getIntermediateResult:(_,e,E)=>{let t={};try{t=JSON.parse(UTF8ToString(wasmImports.emscripten_bind_CvrWasm_GetIntermediateResult_0(E)),((_,e)=>["format","possibleFormats","unitType"].includes(_)?BigInt(e):e)),t&&F(t,HEAP8)}catch(_){handleTaskErr(e,_)}handleTaskRes(e,{success:!0,result:t})},cvr_setObservedResultUnitTypes:(_,e,E)=>{try{ep(),wasmImports.emscripten_bind_CvrWasm_SetObservedResultUnitTypes_1(E,es(_.types))}catch(_){handleTaskErr(e,_)}handleTaskRes(e,{success:!0})},cvr_getObservedResultUnitTypes:(_,e,E)=>{let t;try{ep(),t=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_GetObservedResultUnitTypes_0(E))}catch(_){handleTaskErr(e,_)}handleTaskRes(e,{success:!0,result:t})},cvr_isResultUnitTypeObserved:(_,e,E)=>{let t;try{ep(),t=wasmImports.emscripten_bind_CvrWasm_IsResultUnitTypeObserved_1(E,es(_.type))}catch(_){handleTaskErr(e,_)}handleTaskRes(e,{success:!0,result:t})},cvr_capture:async(_,e,E)=>{let t,s,I;await checkAndReauth(),log(`time worker get msg: ${Date.now()}`);try{let e=Date.now();await V(E,_),log("appendResourceTime: "+(Date.now()-e)),y&&(wasmImports.emscripten_bind_Destory_CImageData(y),y=null),y=wasmImports.emscripten_bind_Create_CImageData(_.bytes.length,setBufferIntoWasm(_.bytes,0),_.width,_.height,_.stride,_.format,0);let n=Date.now();log(`start worker capture: ${n}`),ep(),s=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_Capture_3(E,y,es(_.templateName),_.isScanner));let C=Date.now();log("worker time: "+(C-n)),log(`end worker capture: ${C}`),s=JSON.parse(s,(function(_,e){return"format"!==_||r(this)?e:BigInt(e)}));let T=Date.now();log("capture result parsed: "+(T-C));for(let _=0;_<s.items.length;_++)[L.CRIT_NORMALIZED_IMAGE].includes(s.items[_].type)&&(I=s.items[_].imageData.bytes,I=new Uint8Array(new Uint8Array(HEAP8.buffer,I.ptr,I.length)),s.items[_].imageData.bytes=I);let a=Date.now();log("result new Uint8Array: "+(a-T)),t=JSON.parse(UTF8ToString(wasmImports.emscripten_bind_CvrWasm_GetIntermediateResult_0(E)),((_,e)=>["format","possibleFormats","unitType"].includes(_)?BigInt(e):e)),t&&F(t,HEAP8),s.intermediateResult=t;let A=Date.now();log("get intermediate result: "+(A-a)),log("after capture handle time: "+(Date.now()-C))}catch(_){return void handleTaskErr(e,_)}const n=Date.now();log(`time worker return msg: ${n}`),postMessage({type:"task",id:e,body:{success:!0,bytes:_.bytes,captureResult:s,workerReturnMsgTime:n}},[_.bytes.buffer])},cvr_outputSettings:async(_,e,E)=>{let t;try{ep(),t=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_OutputSettings_1(E,es(_.templateName))),handleTaskRes(e,{success:!0,response:t})}catch(_){handleTaskErr(e,_)}},cvr_getTemplateNames:async(_,e,E)=>{let t;try{ep(),t=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_GetTemplateNames_0(E)),handleTaskRes(e,{success:!0,response:t})}catch(_){console.log(_),handleTaskErr(e,_)}},cvr_getSimplifiedSettings:async(_,e,E)=>{let t;try{ep(),t=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_GetSimplifiedSettings_1(E,es(_.templateName))),handleTaskRes(e,{success:!0,response:t})}catch(_){handleTaskErr(e,_)}},cvr_updateSettings:async(_,e,E)=>{let t,s=!1;try{let I=_.settings,r=_.templateName;"object"==typeof I&&I.hasOwnProperty("barcodeSettings")&&(I.barcodeSettings.barcodeFormatIds=I.barcodeSettings.barcodeFormatIds.toString()),ep(),t=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_UpdateSettings_2(E,es(r),es(JSON.stringify(I)))),ep();const n=JSON.parse(UTF8ToString(wasmImports.emscripten_bind_CvrWasm_OutputSettings_1(E,es(r))));if(!n.errorCode){s=1===JSON.parse(n.data).CaptureVisionTemplates[0].OutputOriginalImage}handleTaskRes(e,{success:!0,response:t,isOutputOriginalImage:s})}catch(_){handleTaskErr(e,_)}},cvr_resetSettings:async(_,e,E)=>{let t;try{wasmImports.emscripten_bind_CvrWasm_ResetSettings_0(E),ep(),P&&wasmImports.emscripten_bind_CvrWasm_AppendParameterContent_1(E,es(P)),ep(),f&&wasmImports.emscripten_bind_CvrWasm_AppendParameterContent_1(E,es(f)),ep(),G&&wasmImports.emscripten_bind_CvrWasm_AppendParameterContent_1(E,es(G)),ep(),t=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_InitParameter_0(E)),handleTaskRes(e,{success:!0,response:t})}catch(_){handleTaskErr(e,_)}},cvr_getMaxBufferedItems:async(_,e,E)=>{let t;try{t=wasmImports.emscripten_bind_CvrWasm_GetMaxBufferedItems_0(E),handleTaskRes(e,{success:!0,count:t})}catch(_){handleTaskErr(e,_)}},cvr_setMaxBufferedItems:async(_,e,E)=>{let t;try{t=wasmImports.emscripten_bind_CvrWasm_SetMaxBufferedItems_1(E,_.count),handleTaskRes(e,{success:!0})}catch(_){handleTaskErr(e,_)}},cvr_getBufferedCharacterItemSet:async(_,e,E)=>{let t;try{t=JSON.parse(UTF8ToString(wasmImports.emscripten_bind_CvrWasm_GetBufferedCharacterItemSet_0(E)));for(let _ of t.items){let e=_.image.bytes;e&&(e=new Uint8Array(new Uint8Array(HEAP8.buffer,e.ptr,e.length)),_.image.bytes=e)}for(let _ of t.characterClusters){let e=_.mean.image.bytes;e&&(e=new Uint8Array(new Uint8Array(HEAP8.buffer,e.ptr,e.length)),_.mean.image.bytes=e)}handleTaskRes(e,{success:!0,itemSet:t})}catch(_){handleTaskErr(e,_)}},cvr_setIrrRegistry:async(_,e,E)=>{try{if(h.has(E)){ep(),wasmImports.emscripten_bind_CvrWasm_SetIrrRegistry_1(E,es(JSON.stringify(_.receiverObj))),_.observedResultUnitTypes&&"-1"!==_.observedResultUnitTypes&&(ep(),wasmImports.emscripten_bind_CvrWasm_SetObservedResultUnitTypes_1(E,es(_.observedResultUnitTypes)));for(let e in _.observedTaskMap)_.observedTaskMap[e]?(ep(),wasmImports.emscripten_bind_CvrWasm_AddObservedTask_1(E,es(e))):(ep(),wasmImports.emscripten_bind_CvrWasm_RemoveObservedTask_1(E,es(e)))}handleTaskRes(e,{success:!0})}catch(_){handleTaskErr(e,_)}},cvr_enableResultCrossVerification:async(_,e,E)=>{let t;try{for(let e in _.verificationEnabled)t=wasmImports.emscripten_bind_CvrWasm_EnableResultCrossVerification_2(E,Number(e),_.verificationEnabled[e]);handleTaskRes(e,{success:!0,result:t})}catch(_){handleTaskErr(e,_)}},cvr_enableResultDeduplication:async(_,e,E)=>{let t;try{for(let e in _.duplicateFilterEnabled)t=wasmImports.emscripten_bind_CvrWasm_EnableResultDeduplication_2(E,Number(e),_.duplicateFilterEnabled[e]);handleTaskRes(e,{success:!0,result:t})}catch(_){handleTaskErr(e,_)}},cvr_setDuplicateForgetTime:async(_,e,E)=>{let t;try{for(let e in _.duplicateForgetTime)t=wasmImports.emscripten_bind_CvrWasm_SetDuplicateForgetTime_2(E,Number(e),_.duplicateForgetTime[e]);handleTaskRes(e,{success:!0,result:t})}catch(_){handleTaskErr(e,_)}},cvr_getDuplicateForgetTime:async(_,e,E)=>{let t;try{t=wasmImports.emscripten_bind_CvrWasm_GetDuplicateForgetTime_1(E,_.type),handleTaskRes(e,{success:!0,time:t})}catch(_){handleTaskErr(e,_)}},cvr_containsTask:async(_,e,E)=>{try{ep();const t=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_ContainsTask_1(E,es(_.templateName)));handleTaskRes(e,{success:!0,tasks:t})}catch(_){handleTaskErr(e,_)}},cvr_dispose:async(_,e,E)=>{try{h.delete(E),wasmImports.emscripten_bind_Destory_CImageData(y),y=null,wasmImports.emscripten_bind_CvrWasm___destroy___0(E),handleTaskRes(e,{success:!0})}catch(_){handleTaskErr(e,_)}},cvr_getWasmFilterState:async(_,e,E)=>{let t;try{t=UTF8ToString(wasmImports.emscripten_bind_CvrWasm_GetFilterState_0(E)),handleTaskRes(e,{success:!0,response:t})}catch(_){handleTaskErr(e,_)}}})}();
