/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft Core JS Edition
 * @website https://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version 3.4.31
 * @fileoverview Dynamsoft JavaScript Library for Core
 * More info on Dynamsoft Core JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/core/core-module.html
 */
const _=_=>_&&"object"==typeof _&&"function"==typeof _.then,E=(async()=>{})().constructor;class e extends E{get status(){return this._s}get isPending(){return"pending"===this._s}get isFulfilled(){return"fulfilled"===this._s}get isRejected(){return"rejected"===this._s}get task(){return this._task}set task(e){let t;this._task=e,_(e)?t=e:"function"==typeof e&&(t=new E(e)),t&&(async()=>{try{const _=await t;e===this._task&&this.resolve(_)}catch(_){e===this._task&&this.reject(_)}})()}get isEmpty(){return null==this._task}constructor(E){let e,t;super(((_,E)=>{e=_,t=E})),this._s="pending",this.resolve=E=>{this.isPending&&(_(E)?this.task=E:(this._s="fulfilled",e(E)))},this.reject=_=>{this.isPending&&(this._s="rejected",t(_))},this.task=E}}function t(_,E,e,t){if("a"===e&&!t)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof E?_!==E||!t:!E.has(_))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===e?t:"a"===e?t.call(_):t?t.value:E.get(_)}function I(_,E,e,t,I){if("m"===t)throw new TypeError("Private method is not writable");if("a"===t&&!I)throw new TypeError("Private accessor was defined without a setter");if("function"==typeof E?_!==E||!I:!E.has(_))throw new TypeError("Cannot write private member to an object whose class did not declare it");return"a"===t?I.call(_,e):I?I.value=e:E.set(_,e),e}var r,s,n;"function"==typeof SuppressedError&&SuppressedError,function(_){_[_.BOPM_BLOCK=0]="BOPM_BLOCK",_[_.BOPM_UPDATE=1]="BOPM_UPDATE"}(r||(r={})),function(_){_[_.CCUT_AUTO=0]="CCUT_AUTO",_[_.CCUT_FULL_CHANNEL=1]="CCUT_FULL_CHANNEL",_[_.CCUT_Y_CHANNEL_ONLY=2]="CCUT_Y_CHANNEL_ONLY",_[_.CCUT_RGB_R_CHANNEL_ONLY=3]="CCUT_RGB_R_CHANNEL_ONLY",_[_.CCUT_RGB_G_CHANNEL_ONLY=4]="CCUT_RGB_G_CHANNEL_ONLY",_[_.CCUT_RGB_B_CHANNEL_ONLY=5]="CCUT_RGB_B_CHANNEL_ONLY"}(s||(s={})),function(_){_[_.IPF_BINARY=0]="IPF_BINARY",_[_.IPF_BINARYINVERTED=1]="IPF_BINARYINVERTED",_[_.IPF_GRAYSCALED=2]="IPF_GRAYSCALED",_[_.IPF_NV21=3]="IPF_NV21",_[_.IPF_RGB_565=4]="IPF_RGB_565",_[_.IPF_RGB_555=5]="IPF_RGB_555",_[_.IPF_RGB_888=6]="IPF_RGB_888",_[_.IPF_ARGB_8888=7]="IPF_ARGB_8888",_[_.IPF_RGB_161616=8]="IPF_RGB_161616",_[_.IPF_ARGB_16161616=9]="IPF_ARGB_16161616",_[_.IPF_ABGR_8888=10]="IPF_ABGR_8888",_[_.IPF_ABGR_16161616=11]="IPF_ABGR_16161616",_[_.IPF_BGR_888=12]="IPF_BGR_888",_[_.IPF_BINARY_8=13]="IPF_BINARY_8",_[_.IPF_NV12=14]="IPF_NV12",_[_.IPF_BINARY_8_INVERTED=15]="IPF_BINARY_8_INVERTED"}(n||(n={}));const C="undefined"==typeof self,i="function"==typeof importScripts,A=(()=>{if(!i){if(!C&&document.currentScript){let _=document.currentScript.src,E=_.indexOf("?");if(-1!=E)_=_.substring(0,E);else{let E=_.indexOf("#");-1!=E&&(_=_.substring(0,E))}return _.substring(0,_.lastIndexOf("/")+1)}return"./"}})(),o=_=>{if(null==_&&(_="./"),C||i);else{let E=document.createElement("a");E.href=_,_=E.href}return _.endsWith("/")||(_+="/"),_},N=_=>Object.prototype.toString.call(_),a=_=>Array.isArray?Array.isArray(_):"[object Array]"===N(_),T=_=>"[object Boolean]"===N(_),R=_=>"number"==typeof _&&!Number.isNaN(_),L=_=>null!==_&&"object"==typeof _&&!Array.isArray(_),D=_=>!!L(_)&&(!!R(_.x)&&(!!R(_.y)&&(!!R(_.radius)&&(!(_.radius<0)&&(!!R(_.startAngle)&&!!R(_.endAngle)))))),O=_=>!!L(_)&&(!!a(_.points)&&(0!=_.points.length&&!_.points.some((_=>!P(_))))),c=_=>!!L(_)&&(!!R(_.width)&&(!(_.width<=0)&&(!!R(_.height)&&(!(_.height<=0)&&(!!R(_.stride)&&(!(_.stride<=0)&&("format"in _&&!("tag"in _&&!h(_.tag))))))))),S=_=>!!c(_)&&!(!R(_.bytes.length)&&!R(_.bytes.ptr)),l=_=>!!c(_)&&_.bytes instanceof Uint8Array,f=_=>!!L(_)&&(!!R(_.left)&&(!(_.left<0)&&(!!R(_.top)&&(!(_.top<0)&&(!!R(_.right)&&(!(_.right<0)&&(!!R(_.bottom)&&(!(_.bottom<0)&&(!(_.left>=_.right)&&(!(_.top>=_.bottom)&&!!T(_.isMeasuredInPercentage))))))))))),h=_=>null===_||!!L(_)&&(!!R(_.imageId)&&"type"in _),d=_=>!!L(_)&&(!!P(_.startPoint)&&(!!P(_.endPoint)&&(_.startPoint.x!=_.endPoint.x||_.startPoint.y!=_.endPoint.y))),P=_=>!!L(_)&&(!!R(_.x)&&!!R(_.y)),g=_=>!!L(_)&&(!!a(_.points)&&(0!=_.points.length&&!_.points.some((_=>!P(_))))),M=_=>!!L(_)&&(!!a(_.points)&&(0!=_.points.length&&4==_.points.length&&!_.points.some((_=>!P(_))))),u=_=>!!L(_)&&(!!R(_.x)&&(!!R(_.y)&&(!!R(_.width)&&(!(_.width<0)&&(!!R(_.height)&&(!(_.height<0)&&!("isMeasuredInPercentage"in _&&!T(_.isMeasuredInPercentage)))))))),F=async(_,E)=>await new Promise(((e,t)=>{let I=new XMLHttpRequest;I.open("GET",_,!0),I.responseType=E,I.send(),I.onloadend=async()=>{I.status<200||I.status>=300?t(new Error(_+" "+I.status)):e(I.response)},I.onerror=()=>{t(new Error("Network Error: "+I.statusText))}})),G=_=>/^(https:\/\/www\.|http:\/\/www\.|https:\/\/|http:\/\/)|^[a-zA-Z0-9]{2,}(\.[a-zA-Z0-9]{2,})(\.[a-zA-Z0-9]{2,})?/.test(_),U=(_,E)=>{let e=_.split("."),t=E.split(".");for(let _=0;_<e.length&&_<t.length;++_){let E=e[_],I=t[_];if(E===I)continue;let r=parseInt(e[_]),s=parseInt(t[_]);return r===s||Number.isNaN(r)&&Number.isNaN(s)?E<I?-1:1:r<s||Number.isNaN(r)&&Number.isInteger(s)?-1:1}return e.length===t.length?0:e.length<t.length?-1:1},B=_=>{const E={},e={std:"dynamsoft-capture-vision-std",dip:"dynamsoft-image-processing",core:"dynamsoft-core",dnn:"dynamsoft-capture-vision-dnn",license:"dynamsoft-license",utility:"dynamsoft-utility",cvr:"dynamsoft-capture-vision-router",dbr:"dynamsoft-barcode-reader",dlr:"dynamsoft-label-recognizer",ddn:"dynamsoft-document-normalizer",dcp:"dynamsoft-code-parser",dcpd:"dynamsoft-code-parser",dlrData:"dynamsoft-label-recognizer-data",dce:"dynamsoft-camera-enhancer",ddv:"dynamsoft-document-viewer"};for(let t in _){if("rootDirectory"===t)continue;let I=t,r=_[I],s=r&&"object"==typeof r&&r.path?r.path:r,n=_.rootDirectory;if(n&&!n.endsWith("/")&&(n+="/"),"object"==typeof r&&r.isInternal)n&&(s=_[I].version?`${n}${e[I]}@${_[I].version}/dist/${"ddv"===I?"engine":""}`:`${n}${e[I]}/dist/${"ddv"===I?"engine":""}`);else{const e=/^@engineRootDirectory(\/?)/;if("string"==typeof s&&(s=s.replace(e,n||"")),"object"==typeof s&&"dwt"===I){const t=_[I].resourcesPath,r=_[I].serviceInstallerLocation;E[I]={resourcesPath:t.replace(e,n||""),serviceInstallerLocation:r.replace(e,n||"")};continue}}E[I]=o(s)}return E},p=async(_,E,e)=>await new Promise((async(t,I)=>{try{const I=E.split(".");let r=I[I.length-1];const s=await w(`image/${r}`,_);I.length<=1&&(r="png");const n=new File([s],E,{type:`image/${r}`});if(e){const _=URL.createObjectURL(n),e=document.createElement("a");e.href=_,e.download=E,e.click()}return t(n)}catch(_){return I()}})),m=_=>{l(_)&&(_=V(_));const E=document.createElement("canvas");E.width=_.width,E.height=_.height;return E.getContext("2d",{willReadFrequently:!0}).putImageData(_,0,0),E},y=(_,E)=>{l(E)&&(E=V(E));const e=m(E);let t=new Image,I=e.toDataURL(_);return t.src=I,t},w=async(_,E)=>{l(E)&&(E=V(E));const e=m(E);return new Promise(((E,t)=>{e.toBlob((_=>E(_)),_)}))},V=_=>{let E,e=_.bytes;if(!(e&&e instanceof Uint8Array))throw Error("Parameter type error");if(Number(_.format)===n.IPF_BGR_888){const _=e.length/3;E=new Uint8ClampedArray(4*_);for(let t=0;t<_;++t)E[4*t]=e[3*t],E[4*t+1]=e[3*t+1],E[4*t+2]=e[3*t+2],E[4*t+3]=255}else if(Number(_.format)===n.IPF_RGB_888){const _=e.length/3;E=new Uint8ClampedArray(4*_);for(let t=0;t<_;++t)E[4*t]=e[3*t+2],E[4*t+1]=e[3*t+1],E[4*t+2]=e[3*t],E[4*t+3]=255}else if(Number(_.format)===n.IPF_GRAYSCALED){const _=e.length;E=new Uint8ClampedArray(4*_);for(let t=0;t<_;t++)E[4*t]=E[4*t+1]=E[4*t+2]=e[t],E[4*t+3]=255}else if(Number(_.format)===n.IPF_BINARY_8){const t=e.length,I=_.width,r=_.height,s=_.stride;E=new Uint8ClampedArray(I*r*4);for(let _=0;_<t;_++){let t=e[_],r=_%s,n=Math.floor(_/s);for(let _=0;_<8;_++){let e=r+_,s=4*(n*I+e);if(e>=I)break;E[s]=E[s+1]=E[s+2]=(128&t)/128*255,E[s+3]=255,t<<=1}}}else if(Number(_.format)===n.IPF_ABGR_8888){const _=e.length/4;E=new Uint8ClampedArray(e.length);for(let t=0;t<_;++t)E[4*t]=e[4*t],E[4*t+1]=e[4*t+1],E[4*t+2]=e[4*t+2],E[4*t+3]=e[4*t+3]}else if(Number(_.format)===n.IPF_ARGB_8888){const _=e.length/4;E=new Uint8ClampedArray(e.length);for(let t=0;t<_;++t)E[4*t]=e[4*t+2],E[4*t+1]=e[4*t+1],E[4*t+2]=e[4*t],E[4*t+3]=e[4*t+3]}else if(Number(_.format)===n.IPF_BINARY_8_INVERTED){const t=e.length,I=_.width,r=_.height,s=_.stride;E=new Uint8ClampedArray(I*r*4);for(let _=0;_<t;_++){let t=e[_],r=_%s,n=Math.floor(_/s);for(let _=0;_<8;_++){let e=r+_,s=4*(n*I+e);if(e>=I)break;E[s]=E[s+1]=E[s+2]=128&t?0:255,E[s+3]=255,t<<=1}}}return new ImageData(E,_.width,_.height)};var b,v,Y,H,k,X,Z,x;class W{get _isFetchingStarted(){return t(this,k,"f")}constructor(){b.add(this),v.set(this,[]),Y.set(this,1),H.set(this,r.BOPM_BLOCK),k.set(this,!1),X.set(this,void 0),Z.set(this,s.CCUT_AUTO)}setErrorListener(_){}addImageToBuffer(_){var E;if(!l(_))throw new TypeError("Invalid 'image'.");if((null===(E=_.tag)||void 0===E?void 0:E.hasOwnProperty("imageId"))&&"number"==typeof _.tag.imageId&&this.hasImage(_.tag.imageId))throw new Error("Existed imageId.");if(t(this,v,"f").length>=t(this,Y,"f"))switch(t(this,H,"f")){case r.BOPM_BLOCK:break;case r.BOPM_UPDATE:if(t(this,v,"f").push(_),L(t(this,X,"f"))&&R(t(this,X,"f").imageId)&&1==t(this,X,"f").keepInBuffer)for(;t(this,v,"f").length>t(this,Y,"f");){const _=t(this,v,"f").findIndex((_=>{var E;return(null===(E=_.tag)||void 0===E?void 0:E.imageId)!==t(this,X,"f").imageId}));t(this,v,"f").splice(_,1)}else t(this,v,"f").splice(0,t(this,v,"f").length-t(this,Y,"f"))}else t(this,v,"f").push(_)}getImage(){if(0===t(this,v,"f").length)return null;let _;if(t(this,X,"f")&&R(t(this,X,"f").imageId)){const E=t(this,b,"m",x).call(this,t(this,X,"f").imageId);if(E<0)throw new Error(`Image with id ${t(this,X,"f").imageId} doesn't exist.`);_=t(this,v,"f").slice(E,E+1)[0]}else _=t(this,v,"f").pop();if([n.IPF_RGB_565,n.IPF_RGB_555,n.IPF_RGB_888,n.IPF_ARGB_8888,n.IPF_RGB_161616,n.IPF_ARGB_16161616,n.IPF_ABGR_8888,n.IPF_ABGR_16161616,n.IPF_BGR_888].includes(_.format)){if(t(this,Z,"f")===s.CCUT_RGB_R_CHANNEL_ONLY){W._onLog&&W._onLog("only get R channel data.");const E=new Uint8Array(_.width*_.height);for(let e=0;e<E.length;e++)switch(_.format){case n.IPF_RGB_565:case n.IPF_RGB_555:case n.IPF_RGB_888:case n.IPF_RGB_161616:E[e]=_.bytes[3*e+2];break;case n.IPF_ARGB_8888:case n.IPF_ARGB_16161616:E[e]=_.bytes[4*e+2];break;case n.IPF_BGR_888:E[e]=_.bytes[3*e];break;case n.IPF_ABGR_8888:case n.IPF_ABGR_16161616:E[e]=_.bytes[4*e]}_.bytes=E,_.stride=_.width,_.format=n.IPF_GRAYSCALED}else if(t(this,Z,"f")===s.CCUT_RGB_G_CHANNEL_ONLY){W._onLog&&W._onLog("only get G channel data.");const E=new Uint8Array(_.width*_.height);for(let e=0;e<E.length;e++)switch(_.format){case n.IPF_RGB_565:case n.IPF_RGB_555:case n.IPF_RGB_888:case n.IPF_RGB_161616:case n.IPF_BGR_888:E[e]=_.bytes[3*e+1];break;case n.IPF_ARGB_8888:case n.IPF_ARGB_16161616:case n.IPF_ABGR_8888:case n.IPF_ABGR_16161616:E[e]=_.bytes[4*e+1]}_.bytes=E,_.stride=_.width,_.format=n.IPF_GRAYSCALED}else if(t(this,Z,"f")===s.CCUT_RGB_B_CHANNEL_ONLY){W._onLog&&W._onLog("only get B channel data.");const E=new Uint8Array(_.width*_.height);for(let e=0;e<E.length;e++)switch(_.format){case n.IPF_RGB_565:case n.IPF_RGB_555:case n.IPF_RGB_888:case n.IPF_RGB_161616:E[e]=_.bytes[3*e];break;case n.IPF_ARGB_8888:case n.IPF_ARGB_16161616:E[e]=_.bytes[4*e];break;case n.IPF_BGR_888:E[e]=_.bytes[3*e+2];break;case n.IPF_ABGR_8888:case n.IPF_ABGR_16161616:E[e]=_.bytes[4*e+2]}_.bytes=E,_.stride=_.width,_.format=n.IPF_GRAYSCALED}}else[n.IPF_NV21,n.IPF_NV12].includes(_.format)&&W._onLog&&W._onLog("NV21 or NV12 is not supported.");return _}setNextImageToReturn(_,E){if(!((..._)=>0!==_.length&&_.every((_=>R(_))))(_))throw new TypeError("Invalid 'imageId'.");if(void 0!==E&&!T(E))throw new TypeError("Invalid 'keepInBuffer'.");I(this,X,{imageId:_,keepInBuffer:E},"f")}_resetNextReturnedImage(){I(this,X,null,"f")}hasImage(_){return t(this,b,"m",x).call(this,_)>=0}startFetching(){I(this,k,!0,"f")}stopFetching(){I(this,k,!1,"f")}setMaxImageCount(_){if("number"!=typeof _)throw new TypeError("Invalid 'count'.");if(_<1||Math.round(_)!==_)throw new Error("Invalid 'count'.");for(I(this,Y,_,"f");t(this,v,"f")&&t(this,v,"f").length>_;)t(this,v,"f").shift()}getMaxImageCount(){return t(this,Y,"f")}getImageCount(){return t(this,v,"f").length}clearBuffer(){t(this,v,"f").length=0}isBufferEmpty(){return 0===t(this,v,"f").length}setBufferOverflowProtectionMode(_){I(this,H,_,"f")}getBufferOverflowProtectionMode(){return t(this,H,"f")}setColourChannelUsageType(_){I(this,Z,_,"f")}getColourChannelUsageType(){return t(this,Z,"f")}}let j,K,J,Q,$;v=new WeakMap,Y=new WeakMap,H=new WeakMap,k=new WeakMap,X=new WeakMap,Z=new WeakMap,b=new WeakSet,x=function(_){if("number"!=typeof _)throw new TypeError("Invalid 'imageId'.");return t(this,v,"f").findIndex((E=>{var e;return(null===(e=E.tag)||void 0===e?void 0:e.imageId)===_}))},"undefined"!=typeof navigator&&(j=navigator,K=j.userAgent,J=j.platform,Q=j.mediaDevices),function(){if(!C){const _={Edge:{search:"Edg",verSearch:"Edg"},OPR:null,Chrome:null,Safari:{str:j.vendor,search:"Apple",verSearch:["Version","iPhone OS","CPU OS"]},Firefox:null,Explorer:{search:"MSIE",verSearch:"MSIE"}},E={HarmonyOS:null,Android:null,iPhone:null,iPad:null,Windows:{str:J,search:"Win"},Mac:{str:J},Linux:{str:J}};let e="unknownBrowser",t=0,I="unknownOS";for(let E in _){const I=_[E]||{};let r=I.str||K,s=I.search||E,n=I.verStr||K,C=I.verSearch||E;if(C instanceof Array||(C=[C]),-1!=r.indexOf(s)){e=E;for(let _ of C){let E=n.indexOf(_);if(-1!=E){t=parseFloat(n.substring(E+_.length+1));break}}break}}for(let _ in E){const e=E[_]||{};let t=e.str||K,r=e.search||_;if(-1!=t.indexOf(r)){I=_;break}}"Linux"==I&&-1!=K.indexOf("Windows NT")&&(I="HarmonyOS"),$={browser:e,version:t,OS:I}}C&&($={browser:"ssr",version:0,OS:"ssr"})}();const z="undefined"!=typeof WebAssembly&&K&&!(/Safari/.test(K)&&!/Chrome/.test(K)&&/\(.+\s11_2_([2-6]).*\)/.test(K)),q=!("undefined"==typeof Worker),__=!(!Q||!Q.getUserMedia),E_=async()=>{let _=!1;if(__)try{(await Q.getUserMedia({video:!0})).getTracks().forEach((_=>{_.stop()})),_=!0}catch(_){}return _};"Chrome"===$.browser&&$.version>66||"Safari"===$.browser&&$.version>13||"OPR"===$.browser&&$.version>43||"Edge"===$.browser&&$.version;const e_={},t_=async _=>{let E="string"==typeof _?[_]:_,t=[];for(let _ of E)t.push(e_[_]=e_[_]||new e);await Promise.all(t)},I_=async(_,E)=>{let t,I="string"==typeof _?[_]:_,r=[];for(let _ of I){let I;r.push(I=e_[_]=e_[_]||new e(t=t||E())),I.isEmpty&&(I.task=t=t||E())}await Promise.all(r)};let r_,s_=0;const n_=()=>s_++,C_={};let i_;const A_=_=>{i_=_,r_&&r_.postMessage({type:"setBLog",body:{value:!!_}})};let o_=!1;const N_=_=>{o_=_,r_&&r_.postMessage({type:"setBDebug",body:{value:!!_}})},a_={},T_={},R_={dip:{wasm:!0}},L_={std:{version:"1.4.21",path:o(A+"../../dynamsoft-capture-vision-std@1.4.21/dist/"),isInternal:!0},core:{version:"3.4.31",path:A,isInternal:!0}},D_=async _=>{let E;_ instanceof Array||(_=_?[_]:[]);let t=e_.core;E=!t||t.isEmpty;let I=new Map;const r=_=>{if("std"==(_=_.toLowerCase())||"core"==_)return;if(!R_[_])throw Error("The '"+_+"' module cannot be found.");let E=R_[_].deps;if(null==E?void 0:E.length)for(let _ of E)r(_);let e=e_[_];I.has(_)||I.set(_,!e||e.isEmpty)};for(let E of _)r(E);let s=[];E&&s.push("core"),s.push(...I.keys());const n=[...I.entries()].filter((_=>!_[1])).map((_=>_[0]));await I_(s,(async()=>{const _=[...I.entries()].filter((_=>_[1])).map((_=>_[0]));await t_(n);const t=B(L_),r={};for(let E of _)r[E]=R_[E];const s={engineResourcePaths:t,autoResources:r,names:_};let C=new e;if(E){s.needLoadCore=!0;let _=t.core+O_._workerName;_.startsWith(location.origin)||(_=await fetch(_).then((_=>_.blob())).then((_=>URL.createObjectURL(_)))),r_=new Worker(_),r_.onerror=_=>{let E=new Error(_.message);C.reject(E)},r_.addEventListener("message",(_=>{let E=_.data?_.data:_,e=E.type,t=E.id,I=E.body;switch(e){case"log":i_&&i_(E.message);break;case"task":try{C_[t](I),delete C_[t]}catch(_){throw delete C_[t],_}break;case"event":try{C_[t](I)}catch(_){throw _}break;default:console.log(_)}})),s.bLog=!!i_,s.bd=o_,s.dm=location.origin.startsWith("http")?location.origin:"https://localhost"}else await t_("core");let i=s_++;C_[i]=_=>{if(_.success)Object.assign(a_,_.versions),"{}"!==JSON.stringify(_.versions)&&(O_._versions=_.versions),C.resolve(void 0);else{const E=Error(_.message);_.stack&&(E.stack=_.stack),C.reject(E)}},r_.postMessage({type:"loadWasm",body:s,id:i}),await C}))};class O_{static get engineResourcePaths(){return L_}static set engineResourcePaths(_){Object.assign(L_,_)}static get bSupportDce4Module(){return this._bSupportDce4Module}static get bSupportIRTModule(){return this._bSupportIRTModule}static get versions(){return this._versions}static get _onLog(){return i_}static set _onLog(_){A_(_)}static get _bDebug(){return o_}static set _bDebug(_){N_(_)}static isModuleLoaded(_){return _=(_=_||"core").toLowerCase(),!!e_[_]&&e_[_].isFulfilled}static async loadWasm(_){return await D_(_)}static async detectEnvironment(){return await(async()=>({wasm:z,worker:q,getUserMedia:__,camera:await E_(),browser:$.browser,version:$.version,OS:$.OS}))()}static async getModuleVersion(){return await new Promise(((_,E)=>{let e=n_();C_[e]=async e=>{if(e.success)return _(e.versions);{let _=new Error(e.message);return _.stack=e.stack+"\n"+_.stack,E(_)}},r_.postMessage({type:"getModuleVersion",id:e})}))}static getVersion(){const _=a_.core&&a_.core.worker,E=a_.core&&a_.core.wasm;return`3.4.31(Worker: ${_||"Not Loaded"}, Wasm: ${E||"Not Loaded"})`}static enableLogging(){W._onLog=console.log,O_._onLog=console.log}static disableLogging(){W._onLog=null,O_._onLog=null}static async cfd(_){return await new Promise(((E,e)=>{let t=n_();C_[t]=async _=>{if(_.success)return E();{let E=new Error(_.message);return E.stack=_.stack+"\n"+E.stack,e(E)}},r_.postMessage({type:"cfd",id:t,body:{count:_}})}))}}var c_,S_,l_,f_,h_,d_,P_,g_,M_;O_._bSupportDce4Module=-1,O_._bSupportIRTModule=-1,O_._versions=null,O_._workerName="core.worker.js",O_.browserInfo=$,function(_){_[_.CRIT_ORIGINAL_IMAGE=1]="CRIT_ORIGINAL_IMAGE",_[_.CRIT_BARCODE=2]="CRIT_BARCODE",_[_.CRIT_TEXT_LINE=4]="CRIT_TEXT_LINE",_[_.CRIT_DETECTED_QUAD=8]="CRIT_DETECTED_QUAD",_[_.CRIT_NORMALIZED_IMAGE=16]="CRIT_NORMALIZED_IMAGE",_[_.CRIT_PARSED_RESULT=32]="CRIT_PARSED_RESULT"}(c_||(c_={})),function(_){_[_.CT_NORMAL_INTERSECTED=0]="CT_NORMAL_INTERSECTED",_[_.CT_T_INTERSECTED=1]="CT_T_INTERSECTED",_[_.CT_CROSS_INTERSECTED=2]="CT_CROSS_INTERSECTED",_[_.CT_NOT_INTERSECTED=3]="CT_NOT_INTERSECTED"}(S_||(S_={})),function(_){_[_.EC_OK=0]="EC_OK",_[_.EC_UNKNOWN=-1e4]="EC_UNKNOWN",_[_.EC_NO_MEMORY=-10001]="EC_NO_MEMORY",_[_.EC_NULL_POINTER=-10002]="EC_NULL_POINTER",_[_.EC_LICENSE_INVALID=-10003]="EC_LICENSE_INVALID",_[_.EC_LICENSE_EXPIRED=-10004]="EC_LICENSE_EXPIRED",_[_.EC_FILE_NOT_FOUND=-10005]="EC_FILE_NOT_FOUND",_[_.EC_FILE_TYPE_NOT_SUPPORTED=-10006]="EC_FILE_TYPE_NOT_SUPPORTED",_[_.EC_BPP_NOT_SUPPORTED=-10007]="EC_BPP_NOT_SUPPORTED",_[_.EC_INDEX_INVALID=-10008]="EC_INDEX_INVALID",_[_.EC_CUSTOM_REGION_INVALID=-10010]="EC_CUSTOM_REGION_INVALID",_[_.EC_IMAGE_READ_FAILED=-10012]="EC_IMAGE_READ_FAILED",_[_.EC_TIFF_READ_FAILED=-10013]="EC_TIFF_READ_FAILED",_[_.EC_DIB_BUFFER_INVALID=-10018]="EC_DIB_BUFFER_INVALID",_[_.EC_PDF_READ_FAILED=-10021]="EC_PDF_READ_FAILED",_[_.EC_PDF_DLL_MISSING=-10022]="EC_PDF_DLL_MISSING",_[_.EC_PAGE_NUMBER_INVALID=-10023]="EC_PAGE_NUMBER_INVALID",_[_.EC_CUSTOM_SIZE_INVALID=-10024]="EC_CUSTOM_SIZE_INVALID",_[_.EC_TIMEOUT=-10026]="EC_TIMEOUT",_[_.EC_JSON_PARSE_FAILED=-10030]="EC_JSON_PARSE_FAILED",_[_.EC_JSON_TYPE_INVALID=-10031]="EC_JSON_TYPE_INVALID",_[_.EC_JSON_KEY_INVALID=-10032]="EC_JSON_KEY_INVALID",_[_.EC_JSON_VALUE_INVALID=-10033]="EC_JSON_VALUE_INVALID",_[_.EC_JSON_NAME_KEY_MISSING=-10034]="EC_JSON_NAME_KEY_MISSING",_[_.EC_JSON_NAME_VALUE_DUPLICATED=-10035]="EC_JSON_NAME_VALUE_DUPLICATED",_[_.EC_TEMPLATE_NAME_INVALID=-10036]="EC_TEMPLATE_NAME_INVALID",_[_.EC_JSON_NAME_REFERENCE_INVALID=-10037]="EC_JSON_NAME_REFERENCE_INVALID",_[_.EC_PARAMETER_VALUE_INVALID=-10038]="EC_PARAMETER_VALUE_INVALID",_[_.EC_DOMAIN_NOT_MATCH=-10039]="EC_DOMAIN_NOT_MATCH",_[_.EC_RESERVED_INFO_NOT_MATCH=-10040]="EC_RESERVED_INFO_NOT_MATCH",_[_.EC_LICENSE_KEY_NOT_MATCH=-10043]="EC_LICENSE_KEY_NOT_MATCH",_[_.EC_REQUEST_FAILED=-10044]="EC_REQUEST_FAILED",_[_.EC_LICENSE_INIT_FAILED=-10045]="EC_LICENSE_INIT_FAILED",_[_.EC_SET_MODE_ARGUMENT_ERROR=-10051]="EC_SET_MODE_ARGUMENT_ERROR",_[_.EC_LICENSE_CONTENT_INVALID=-10052]="EC_LICENSE_CONTENT_INVALID",_[_.EC_LICENSE_KEY_INVALID=-10053]="EC_LICENSE_KEY_INVALID",_[_.EC_LICENSE_DEVICE_RUNS_OUT=-10054]="EC_LICENSE_DEVICE_RUNS_OUT",_[_.EC_GET_MODE_ARGUMENT_ERROR=-10055]="EC_GET_MODE_ARGUMENT_ERROR",_[_.EC_IRT_LICENSE_INVALID=-10056]="EC_IRT_LICENSE_INVALID",_[_.EC_FILE_SAVE_FAILED=-10058]="EC_FILE_SAVE_FAILED",_[_.EC_STAGE_TYPE_INVALID=-10059]="EC_STAGE_TYPE_INVALID",_[_.EC_IMAGE_ORIENTATION_INVALID=-10060]="EC_IMAGE_ORIENTATION_INVALID",_[_.EC_CONVERT_COMPLEX_TEMPLATE_ERROR=-10061]="EC_CONVERT_COMPLEX_TEMPLATE_ERROR",_[_.EC_CALL_REJECTED_WHEN_CAPTURING=-10062]="EC_CALL_REJECTED_WHEN_CAPTURING",_[_.EC_NO_IMAGE_SOURCE=-10063]="EC_NO_IMAGE_SOURCE",_[_.EC_READ_DIRECTORY_FAILED=-10064]="EC_READ_DIRECTORY_FAILED",_[_.EC_MODULE_NOT_FOUND=-10065]="EC_MODULE_NOT_FOUND",_[_.EC_MULTI_PAGES_NOT_SUPPORTED=-10066]="EC_MULTI_PAGES_NOT_SUPPORTED",_[_.EC_FILE_ALREADY_EXISTS=-10067]="EC_FILE_ALREADY_EXISTS",_[_.EC_CREATE_FILE_FAILED=-10068]="EC_CREATE_FILE_FAILED",_[_.EC_IMGAE_DATA_INVALID=-10069]="EC_IMGAE_DATA_INVALID",_[_.EC_IMAGE_SIZE_NOT_MATCH=-10070]="EC_IMAGE_SIZE_NOT_MATCH",_[_.EC_IMAGE_PIXEL_FORMAT_NOT_MATCH=-10071]="EC_IMAGE_PIXEL_FORMAT_NOT_MATCH",_[_.EC_SECTION_LEVEL_RESULT_IRREPLACEABLE=-10072]="EC_SECTION_LEVEL_RESULT_IRREPLACEABLE",_[_.EC_AXIS_DEFINITION_INCORRECT=-10073]="EC_AXIS_DEFINITION_INCORRECT",_[_.EC_RESULT_TYPE_MISMATCH_IRREPLACEABLE=-10074]="EC_RESULT_TYPE_MISMATCH_IRREPLACEABLE",_[_.EC_PDF_LIBRARY_LOAD_FAILED=-10075]="EC_PDF_LIBRARY_LOAD_FAILED",_[_.EC_NO_LICENSE=-2e4]="EC_NO_LICENSE",_[_.EC_HANDSHAKE_CODE_INVALID=-20001]="EC_HANDSHAKE_CODE_INVALID",_[_.EC_LICENSE_BUFFER_FAILED=-20002]="EC_LICENSE_BUFFER_FAILED",_[_.EC_LICENSE_SYNC_FAILED=-20003]="EC_LICENSE_SYNC_FAILED",_[_.EC_DEVICE_NOT_MATCH=-20004]="EC_DEVICE_NOT_MATCH",_[_.EC_BIND_DEVICE_FAILED=-20005]="EC_BIND_DEVICE_FAILED",_[_.EC_INSTANCE_COUNT_OVER_LIMIT=-20008]="EC_INSTANCE_COUNT_OVER_LIMIT",_[_.EC_LICENSE_INIT_SEQUENCE_FAILED=-20009]="EC_LICENSE_INIT_SEQUENCE_FAILED",_[_.EC_TRIAL_LICENSE=-20010]="EC_TRIAL_LICENSE",_[_.EC_FAILED_TO_REACH_DLS=-20200]="EC_FAILED_TO_REACH_DLS",_[_.EC_LICENSE_CACHE_USED=-20012]="EC_LICENSE_CACHE_USED",_[_.EC_BARCODE_FORMAT_INVALID=-30009]="EC_BARCODE_FORMAT_INVALID",_[_.EC_QR_LICENSE_INVALID=-30016]="EC_QR_LICENSE_INVALID",_[_.EC_1D_LICENSE_INVALID=-30017]="EC_1D_LICENSE_INVALID",_[_.EC_PDF417_LICENSE_INVALID=-30019]="EC_PDF417_LICENSE_INVALID",_[_.EC_DATAMATRIX_LICENSE_INVALID=-30020]="EC_DATAMATRIX_LICENSE_INVALID",_[_.EC_CUSTOM_MODULESIZE_INVALID=-30025]="EC_CUSTOM_MODULESIZE_INVALID",_[_.EC_AZTEC_LICENSE_INVALID=-30041]="EC_AZTEC_LICENSE_INVALID",_[_.EC_PATCHCODE_LICENSE_INVALID=-30046]="EC_PATCHCODE_LICENSE_INVALID",_[_.EC_POSTALCODE_LICENSE_INVALID=-30047]="EC_POSTALCODE_LICENSE_INVALID",_[_.EC_DPM_LICENSE_INVALID=-30048]="EC_DPM_LICENSE_INVALID",_[_.EC_FRAME_DECODING_THREAD_EXISTS=-30049]="EC_FRAME_DECODING_THREAD_EXISTS",_[_.EC_STOP_DECODING_THREAD_FAILED=-30050]="EC_STOP_DECODING_THREAD_FAILED",_[_.EC_MAXICODE_LICENSE_INVALID=-30057]="EC_MAXICODE_LICENSE_INVALID",_[_.EC_GS1_DATABAR_LICENSE_INVALID=-30058]="EC_GS1_DATABAR_LICENSE_INVALID",_[_.EC_GS1_COMPOSITE_LICENSE_INVALID=-30059]="EC_GS1_COMPOSITE_LICENSE_INVALID",_[_.EC_DOTCODE_LICENSE_INVALID=-30061]="EC_DOTCODE_LICENSE_INVALID",_[_.EC_PHARMACODE_LICENSE_INVALID=-30062]="EC_PHARMACODE_LICENSE_INVALID",_[_.EC_CHARACTER_MODEL_FILE_NOT_FOUND=-40100]="EC_CHARACTER_MODEL_FILE_NOT_FOUND",_[_.EC_TEXT_LINE_GROUP_LAYOUT_CONFLICT=-40101]="EC_TEXT_LINE_GROUP_LAYOUT_CONFLICT",_[_.EC_TEXT_LINE_GROUP_REGEX_CONFLICT=-40102]="EC_TEXT_LINE_GROUP_REGEX_CONFLICT",_[_.EC_QUADRILATERAL_INVALID=-50057]="EC_QUADRILATERAL_INVALID",_[_.EC_PANORAMA_LICENSE_INVALID=-70060]="EC_PANORAMA_LICENSE_INVALID",_[_.EC_RESOURCE_PATH_NOT_EXIST=-90001]="EC_RESOURCE_PATH_NOT_EXIST",_[_.EC_RESOURCE_LOAD_FAILED=-90002]="EC_RESOURCE_LOAD_FAILED",_[_.EC_CODE_SPECIFICATION_NOT_FOUND=-90003]="EC_CODE_SPECIFICATION_NOT_FOUND",_[_.EC_FULL_CODE_EMPTY=-90004]="EC_FULL_CODE_EMPTY",_[_.EC_FULL_CODE_PREPROCESS_FAILED=-90005]="EC_FULL_CODE_PREPROCESS_FAILED",_[_.EC_ZA_DL_LICENSE_INVALID=-90006]="EC_ZA_DL_LICENSE_INVALID",_[_.EC_AAMVA_DL_ID_LICENSE_INVALID=-90007]="EC_AAMVA_DL_ID_LICENSE_INVALID",_[_.EC_AADHAAR_LICENSE_INVALID=-90008]="EC_AADHAAR_LICENSE_INVALID",_[_.EC_MRTD_LICENSE_INVALID=-90009]="EC_MRTD_LICENSE_INVALID",_[_.EC_VIN_LICENSE_INVALID=-90010]="EC_VIN_LICENSE_INVALID",_[_.EC_CUSTOMIZED_CODE_TYPE_LICENSE_INVALID=-90011]="EC_CUSTOMIZED_CODE_TYPE_LICENSE_INVALID",_[_.EC_LICENSE_WARNING=-10076]="EC_LICENSE_WARNING",_[_.EC_BARCODE_READER_LICENSE_NOT_FOUND=-30063]="EC_BARCODE_READER_LICENSE_NOT_FOUND",_[_.EC_LABEL_RECOGNIZER_LICENSE_NOT_FOUND=-40103]="EC_LABEL_RECOGNIZER_LICENSE_NOT_FOUND",_[_.EC_DOCUMENT_NORMALIZER_LICENSE_NOT_FOUND=-50058]="EC_DOCUMENT_NORMALIZER_LICENSE_NOT_FOUND",_[_.EC_CODE_PARSER_LICENSE_NOT_FOUND=-90012]="EC_CODE_PARSER_LICENSE_NOT_FOUND"}(l_||(l_={})),function(_){_[_.GEM_SKIP=0]="GEM_SKIP",_[_.GEM_AUTO=1]="GEM_AUTO",_[_.GEM_GENERAL=2]="GEM_GENERAL",_[_.GEM_GRAY_EQUALIZE=4]="GEM_GRAY_EQUALIZE",_[_.GEM_GRAY_SMOOTH=8]="GEM_GRAY_SMOOTH",_[_.GEM_SHARPEN_SMOOTH=16]="GEM_SHARPEN_SMOOTH",_[_.GEM_REV=-2147483648]="GEM_REV"}(f_||(f_={})),function(_){_[_.GTM_SKIP=0]="GTM_SKIP",_[_.GTM_INVERTED=1]="GTM_INVERTED",_[_.GTM_ORIGINAL=2]="GTM_ORIGINAL",_[_.GTM_AUTO=4]="GTM_AUTO",_[_.GTM_REV=-2147483648]="GTM_REV"}(h_||(h_={})),function(_){_[_.ITT_FILE_IMAGE=0]="ITT_FILE_IMAGE",_[_.ITT_VIDEO_FRAME=1]="ITT_VIDEO_FRAME"}(d_||(d_={})),function(_){_[_.PDFRM_VECTOR=1]="PDFRM_VECTOR",_[_.PDFRM_RASTER=2]="PDFRM_RASTER",_[_.PDFRM_REV=-2147483648]="PDFRM_REV"}(P_||(P_={})),function(_){_[_.RDS_RASTERIZED_PAGES=0]="RDS_RASTERIZED_PAGES",_[_.RDS_EXTRACTED_IMAGES=1]="RDS_EXTRACTED_IMAGES"}(g_||(g_={})),function(_){_[_.CVS_NOT_VERIFIED=0]="CVS_NOT_VERIFIED",_[_.CVS_PASSED=1]="CVS_PASSED",_[_.CVS_FAILED=2]="CVS_FAILED"}(M_||(M_={}));const u_={IRUT_NULL:BigInt(0),IRUT_COLOUR_IMAGE:BigInt(1),IRUT_SCALED_DOWN_COLOUR_IMAGE:BigInt(2),IRUT_GRAYSCALE_IMAGE:BigInt(4),IRUT_TRANSOFORMED_GRAYSCALE_IMAGE:BigInt(8),IRUT_ENHANCED_GRAYSCALE_IMAGE:BigInt(16),IRUT_PREDETECTED_REGIONS:BigInt(32),IRUT_BINARY_IMAGE:BigInt(64),IRUT_TEXTURE_DETECTION_RESULT:BigInt(128),IRUT_TEXTURE_REMOVED_GRAYSCALE_IMAGE:BigInt(256),IRUT_TEXTURE_REMOVED_BINARY_IMAGE:BigInt(512),IRUT_CONTOURS:BigInt(1024),IRUT_LINE_SEGMENTS:BigInt(2048),IRUT_TEXT_ZONES:BigInt(4096),IRUT_TEXT_REMOVED_BINARY_IMAGE:BigInt(8192),IRUT_CANDIDATE_BARCODE_ZONES:BigInt(16384),IRUT_LOCALIZED_BARCODES:BigInt(32768),IRUT_SCALED_UP_BARCODE_IMAGE:BigInt(65536),IRUT_DEFORMATION_RESISTED_BARCODE_IMAGE:BigInt(1<<17),IRUT_COMPLEMENTED_BARCODE_IMAGE:BigInt(1<<18),IRUT_DECODED_BARCODES:BigInt(1<<19),IRUT_LONG_LINES:BigInt(1<<20),IRUT_CORNERS:BigInt(1<<21),IRUT_CANDIDATE_QUAD_EDGES:BigInt(1<<22),IRUT_DETECTED_QUADS:BigInt(1<<23),IRUT_LOCALIZED_TEXT_LINES:BigInt(1<<24),IRUT_RECOGNIZED_TEXT_LINES:BigInt(1<<25),IRUT_NORMALIZED_IMAGES:BigInt(1<<26),IRUT_SHORT_LINES:BigInt(1<<27),IRUT_RAW_TEXT_LINES:BigInt(1<<28),IRUT_LOGIC_LINES:BigInt(1<<29),IRUT_ALL:BigInt("0xFFFFFFFFFFFFFFFF")};var F_,G_;!function(_){_[_.ROET_PREDETECTED_REGION=0]="ROET_PREDETECTED_REGION",_[_.ROET_LOCALIZED_BARCODE=1]="ROET_LOCALIZED_BARCODE",_[_.ROET_DECODED_BARCODE=2]="ROET_DECODED_BARCODE",_[_.ROET_LOCALIZED_TEXT_LINE=3]="ROET_LOCALIZED_TEXT_LINE",_[_.ROET_RECOGNIZED_TEXT_LINE=4]="ROET_RECOGNIZED_TEXT_LINE",_[_.ROET_DETECTED_QUAD=5]="ROET_DETECTED_QUAD",_[_.ROET_NORMALIZED_IMAGE=6]="ROET_NORMALIZED_IMAGE",_[_.ROET_SOURCE_IMAGE=7]="ROET_SOURCE_IMAGE",_[_.ROET_TARGET_ROI=8]="ROET_TARGET_ROI"}(F_||(F_={})),function(_){_[_.ST_NULL=0]="ST_NULL",_[_.ST_REGION_PREDETECTION=1]="ST_REGION_PREDETECTION",_[_.ST_BARCODE_LOCALIZATION=2]="ST_BARCODE_LOCALIZATION",_[_.ST_BARCODE_DECODING=3]="ST_BARCODE_DECODING",_[_.ST_TEXT_LINE_LOCALIZATION=4]="ST_TEXT_LINE_LOCALIZATION",_[_.ST_TEXT_LINE_RECOGNITION=5]="ST_TEXT_LINE_RECOGNITION",_[_.ST_DOCUMENT_DETECTION=6]="ST_DOCUMENT_DETECTION",_[_.ST_DOCUMENT_NORMALIZATION=7]="ST_DOCUMENT_NORMALIZATION"}(G_||(G_={}));export{O_ as CoreModule,r as EnumBufferOverflowProtectionMode,c_ as EnumCapturedResultItemType,s as EnumColourChannelUsageType,S_ as EnumCornerType,M_ as EnumCrossVerificationStatus,l_ as EnumErrorCode,f_ as EnumGrayscaleEnhancementMode,h_ as EnumGrayscaleTransformationMode,n as EnumImagePixelFormat,d_ as EnumImageTagType,u_ as EnumIntermediateResultUnitType,P_ as EnumPDFReadingMode,g_ as EnumRasterDataSource,F_ as EnumRegionObjectElementType,G_ as EnumSectionType,W as ImageSourceAdapter,V as _getNorImageData,p as _saveToFile,w as _toBlob,m as _toCanvas,y as _toImage,o_ as bDebug,G as checkIsLink,U as compareVersion,I_ as doOrWaitAsyncDependency,n_ as getNextTaskID,B as handleEngineResourcePaths,a_ as innerVersions,D as isArc,O as isContour,l as isDSImageData,f as isDSRect,h as isImageTag,d as isLineSegment,L as isObject,S as isOriginalDsImageData,P as isPoint,g as isPolygon,M as isQuad,u as isRect,D_ as loadWasm,e_ as mapAsyncDependency,T_ as mapPackageRegister,C_ as mapTaskCallBack,i_ as onLog,F as requestResource,N_ as setBDebug,A_ as setOnLog,t_ as waitAsyncDependency,r_ as worker,R_ as workerAutoResources};
