/*!
 * Dynamsoft JavaScript Library
 * @product Dynamsoft Utility JS Edition
 * @website https://www.dynamsoft.com
 * @copyright Copyright 2024, Dynamsoft Corporation
 * @author Dynamsoft
 * @version 1.4.32
 * @fileoverview Dynamsoft JavaScript Library for Utility
 * More info DU JS: https://www.dynamsoft.com/capture-vision/docs/web/programming/javascript/api-reference/utility/utility-module.html
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("dynamsoft-core")):"function"==typeof define&&define.amd?define(["exports","dynamsoft-core"],e):e(((t="undefined"!=typeof globalThis?globalThis:t||self).Dynamsoft=t.Dynamsoft||{},t.Dynamsoft.Utility={}),t.Dynamsoft.Core)}(this,(function(t,e){"use strict";const i=async t=>{let e;await new Promise(((i,n)=>{e=new Image,e.onload=()=>i(e),e.onerror=n,e.src=URL.createObjectURL(t)}));const i=document.createElement("canvas"),n=i.getContext("2d");i.width=e.width,i.height=e.height,n.drawImage(e,0,0);return{bytes:Uint8Array.from(n.getImageData(0,0,i.width,i.height).data),width:i.width,height:i.height,stride:4*i.width,format:10}};const n="undefined"==typeof self,s="function"==typeof importScripts,o=(()=>{if(!s){if(!n&&document.currentScript){let t=document.currentScript.src,e=t.indexOf("?");if(-1!=e)t=t.substring(0,e);else{let e=t.indexOf("#");-1!=e&&(t=t.substring(0,e))}return t.substring(0,t.lastIndexOf("/")+1)}return"./"}})(),a=t=>{if(null==t&&(t="./"),n||s);else{let e=document.createElement("a");e.href=t,t=e.href}return t.endsWith("/")||(t+="/"),t};e.CoreModule.engineResourcePaths.utility={version:"1.4.32",path:o,isInternal:!0},e.workerAutoResources.utility={js:!0,wasm:!0};const r="1.4.21";"string"!=typeof e.CoreModule.engineResourcePaths.std&&e.compareVersion(e.CoreModule.engineResourcePaths.std.version,r)<0&&(e.CoreModule.engineResourcePaths.std={version:r,path:a(o+`../../dynamsoft-capture-vision-std@${r}/dist/`),isInternal:!0});const l="2.4.31";(!e.CoreModule.engineResourcePaths.dip||"string"!=typeof e.CoreModule.engineResourcePaths.dip&&e.compareVersion(e.CoreModule.engineResourcePaths.dip.version,l)<0)&&(e.CoreModule.engineResourcePaths.dip={version:l,path:a(o+`../../dynamsoft-image-processing@${l}/dist/`),isInternal:!0});function c(t,e,i,n){if("a"===i&&!n)throw new TypeError("Private accessor was defined without a getter");if("function"==typeof e?t!==e||!n:!e.has(t))throw new TypeError("Cannot read private member from an object whose class did not declare it");return"m"===i?n:"a"===i?n.call(t):n?n.value:e.get(t)}var u,p,h,f,m;function d(t,e){let i=!0;for(let a=0;a<t.length;a++){const r=(a+1)%t.length;if((n=t[a],s=t[r],o=e,(s.x-n.x)*(o.y-n.y)-(s.y-n.y)*(o.x-n.x))<0){i=!1;break}}var n,s,o;return i}function y(t,e){return Math.sqrt((t.x-e.x)**2+(t.y-e.y)**2)}function g(t,e){const[i,n]=t,s=i.x,o=i.y,a=n.x,r=n.y,l=e.x,c=e.y,u=(a-s)**2+(r-o)**2;if(0===u)return Math.sqrt((l-s)**2+(c-o)**2);const p=((l-s)*(a-s)+(c-o)*(r-o))/u;if(p<0)return Math.sqrt((l-s)**2+(c-o)**2);if(p>1)return Math.sqrt((l-a)**2+(c-r)**2);{const t=s+p*(a-s),e=o+p*(r-o);return Math.sqrt((l-t)**2+(c-e)**2)}}function I(t){const e=[];for(let i=0;i<t.length;i++){const n=t[i],s=t[(i+1)%t.length];e.push([n,s])}return e}function E(t){const[e,i]=t;return{x:(e.x+i.x)/2,y:(e.y+i.y)/2}}function C(t,e){const i=[];for(let n=0;n<4;n++)for(let s=0;s<4;s++){const o=T(t[n],t[(n+1)%4],e[s],e[(s+1)%4]);o&&i.push(o)}t.forEach((t=>{d(e,t)&&i.push(t)})),e.forEach((e=>{d(t,e)&&i.push(e)}));return R(function(t){if(t.length<=1)return t;t.sort(((t,e)=>t.x-e.x||t.y-e.y));const e=t.shift();return t.sort(((t,i)=>Math.atan2(t.y-e.y,t.x-e.x)-Math.atan2(i.y-e.y,i.x-e.x))),[e,...t]}(i))}function T(t,e,i,n){const s=e.x-t.x,o=e.y-t.y,a=n.x-i.x,r=n.y-i.y,l=(-o*(t.x-i.x)+s*(t.y-i.y))/(-a*o+s*r),c=(a*(t.y-i.y)-r*(t.x-i.x))/(-a*o+s*r);return l>=0&&l<=1&&c>=0&&c<=1?{x:t.x+c*s,y:t.y+c*o}:null}function R(t){let e=0;for(let i=0;i<t.length;i++){const n=(i+1)%t.length;e+=t[i].x*t[n].y,e-=t[n].x*t[i].y}return Math.abs(e/2)}function x(t,e,i){let n=e.x-t.x,s=e.y-t.y,o=i.x-t.x;return n*(i.y-t.y)-s*o>0}function v(t,e){for(let i=0;i<4;i++)if(!x(t.points[i],t.points[(i+1)%4],e))return!1;return!0}"function"==typeof SuppressedError&&SuppressedError;const b=3,M=1,_=1,O=2,B=3,D=5,A=15,w=5;function S(t,e,i,n){const s=t.points,o=e.points;let a=8*i;a=Math.max(a,5);const r=I(s)[3],l=I(s)[1],c=I(o)[3],u=I(o)[1];let p,h=0;if(p=Math.max(Math.abs(g(r,e.points[0])),Math.abs(g(r,e.points[3]))),p>h&&(h=p),p=Math.max(Math.abs(g(l,e.points[1])),Math.abs(g(l,e.points[2]))),p>h&&(h=p),p=Math.max(Math.abs(g(c,t.points[0])),Math.abs(g(c,t.points[3]))),p>h&&(h=p),p=Math.max(Math.abs(g(u,t.points[1])),Math.abs(g(u,t.points[2]))),p>h&&(h=p),h>a)return!1;const f=E(I(s)[0]),m=E(I(s)[2]),C=E(I(o)[0]),T=E(I(o)[2]),x=y(f,T),v=y(C,m),b=x>v,M=Math.min(x,v),_=y(f,m),O=y(C,T);let B=12*i;B=Math.max(B,5),B=Math.min(B,_),B=Math.min(B,O);return!!(M<B||d(s,b?C:T)||d(o,b?m:f))&&(b?(n.points[0]=t.points[0],n.points[1]=t.points[1],n.points[2]=e.points[2],n.points[3]=e.points[3]):(n.points[0]=e.points[0],n.points[1]=e.points[1],n.points[2]=t.points[2],n.points[3]=t.points[3]),n.area=R(n.points),!0)}class F{constructor(t,e,i,n){this.overlapCount=t,this.verificationCount=e,this.crossVerificationFrame=5,this.location=n.location,this.locationArea=n.location.area,this.locationAngle=n.angle,this.format=n.format,this.text=n.text,this.isOneD=i,this.item=n;this.locationThreshold=n.moduleSize*D,this.strictLimit=Math.max(this.locationThreshold,1),this.strictLimit=Math.min(this.strictLimit,15)}getCenterPoint(t){const e={x:0,y:0};return t.forEach((({x:t,y:i})=>{e.x+=t,e.y+=i})),e.x/=t.length,e.y/=t.length,e}isProbablySameLocationWithOffset(t,e){const i=this.item.location,n=t.location;if(i.area<=0)return!1;if(Math.abs(i.area-n.area)>.4*i.area)return!1;let s=new Array(4).fill(0),o=new Array(4).fill(0),a=0,r=0;for(let t=0;t<4;++t)s[t]=Math.round(100*(n.points[t].x-i.points[t].x))/100,a+=s[t],o[t]=Math.round(100*(n.points[t].y-i.points[t].y))/100,r+=o[t];a/=4,r/=4;for(let t=0;t<4;++t){if(Math.abs(s[t]-a)>this.strictLimit||Math.abs(a)>.8)return!1;if(Math.abs(o[t]-r)>this.strictLimit||Math.abs(r)>.8)return!1}return e.x=a,e.y=r,!0}isLocationOverlap(t,e){if(this.locationArea>e){for(let e=0;e<4;e++)if(v(this.location,t.points[e]))return!0;const e=this.getCenterPoint(t.points);if(v(this.location,e))return!0}else{for(let e=0;e<4;e++)if(v(t,this.location.points[e]))return!0;if(v(t,this.getCenterPoint(this.location.points)))return!0}return!1}isMatchedLocationWithOffset(t,e={x:0,y:0}){if(this.isOneD){const i=Object.assign({},t.location);for(let t=0;t<4;t++)i.points[t].x-=e.x,i.points[t].y-=e.y;if(!this.isLocationOverlap(i,t.locationArea))return!1;const n=[this.location.points[0],this.location.points[3]],s=[this.location.points[1],this.location.points[2]];for(let t=0;t<4;t++){const e=i.points[t],o=0===t||3===t?n:s;if(Math.abs(g(o,e))>this.locationThreshold)return!1}}else for(let i=0;i<4;i++){const n=t.location.points[i],s=this.location.points[i];if(!(Math.abs(s.x+e.x-n.x)<this.locationThreshold))return!1;if(Math.abs(s.y+e.y-n.y)>=this.locationThreshold)return!1}return!0}isOverlappedLocationWithOffset(t,e,i=!0){const n=Object.assign({},t.location);for(let t=0;t<4;t++)n.points[t].x-=e.x,n.points[t].y-=e.y;if(!this.isLocationOverlap(n,t.location.area))return!1;if(i){const t=.75;return C([...this.location.points],n.points)>this.locationArea*t}return!0}}const L={BF_ONED:BigInt(3147775),BF_GS1_DATABAR:BigInt(260096)},k={barcode:2,text_line:4,detected_quad:8,normalized_image:16},N=t=>Object.values(k).includes(t)||k.hasOwnProperty(t),V=(t,e)=>"string"==typeof t?e[k[t]]:e[t],P=(t,e,i)=>{"string"==typeof t?e[k[t]]=i:e[t]=i},W=(t,e,i)=>{const n=[8,16].includes(i);if(!n&&t.isResultCrossVerificationEnabled(i))for(let t=0;t<e.length;t++)e[t]&&e[t].type===i&&!e[t].verified&&(e[t].isFilter=!0);if(!n&&t.isResultDeduplicationEnabled(i))for(let t=0;t<e.length;t++)e[t]&&e[t].type===i&&e[t].duplicate&&(e[t].isFilter=!0)};u=new WeakMap,p=new WeakMap,h=new WeakMap,f=new WeakMap,m=new WeakMap,t.ImageManager=class{async saveToFile(t,i,n){if(!t||!i)return null;if("string"!=typeof i)throw new TypeError("FileName must be of type string.");const s=e._getNorImageData(t);return e._saveToFile(s,i,n)}async drawOnImage(t,n,s,o=4294901760,a=1,r){let l;if(t instanceof Blob)l=await i(t);else if("string"==typeof t){let n=await e.requestResource(t,"blob");l=await i(n)}return await new Promise(((t,i)=>{let c=e.getNextTaskID();e.mapTaskCallBack[c]=async e=>{if(e.success)return r&&this.saveToFile(e.image,"test.png",r),t(e.image);{let t=new Error(e.message);return t.stack=e.stack+"\n"+t.stack,i(t)}},e.worker.postMessage({type:"utility_drawOnImage",id:c,body:{dsImage:l,drawingItem:n instanceof Array?n:[n],color:o,thickness:a,type:s}})}))}},t.MultiFrameResultCrossFilter=class{constructor(){this.verificationEnabled={[e.EnumCapturedResultItemType.CRIT_BARCODE]:!1,[e.EnumCapturedResultItemType.CRIT_TEXT_LINE]:!0,[e.EnumCapturedResultItemType.CRIT_DETECTED_QUAD]:!0,[e.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE]:!1},this.duplicateFilterEnabled={[e.EnumCapturedResultItemType.CRIT_BARCODE]:!1,[e.EnumCapturedResultItemType.CRIT_TEXT_LINE]:!1,[e.EnumCapturedResultItemType.CRIT_DETECTED_QUAD]:!1,[e.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE]:!1},this.duplicateForgetTime={[e.EnumCapturedResultItemType.CRIT_BARCODE]:3e3,[e.EnumCapturedResultItemType.CRIT_TEXT_LINE]:3e3,[e.EnumCapturedResultItemType.CRIT_DETECTED_QUAD]:3e3,[e.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE]:3e3},this.latestOverlappingEnabled={[e.EnumCapturedResultItemType.CRIT_BARCODE]:!1,[e.EnumCapturedResultItemType.CRIT_TEXT_LINE]:!1,[e.EnumCapturedResultItemType.CRIT_DETECTED_QUAD]:!1,[e.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE]:!1},this.maxOverlappingFrames={[e.EnumCapturedResultItemType.CRIT_BARCODE]:5,[e.EnumCapturedResultItemType.CRIT_TEXT_LINE]:5,[e.EnumCapturedResultItemType.CRIT_DETECTED_QUAD]:5,[e.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE]:5},this.overlapSet=[],this.stabilityCount=0,this.crossVerificationFrames=5,u.set(this,new Map),p.set(this,new Map),h.set(this,new Map),f.set(this,new Map),m.set(this,new Map)}_dynamsoft(){c(this,u,"f").forEach(((t,e)=>{P(e,this.verificationEnabled,t)})),c(this,p,"f").forEach(((t,e)=>{P(e,this.duplicateFilterEnabled,t)})),c(this,h,"f").forEach(((t,e)=>{P(e,this.duplicateForgetTime,t)})),c(this,f,"f").forEach(((t,e)=>{P(e,this.latestOverlappingEnabled,t)})),c(this,m,"f").forEach(((t,e)=>{P(e,this.maxOverlappingFrames,t)}))}enableResultCrossVerification(t,e){N(t)&&c(this,u,"f").set(t,e)}isResultCrossVerificationEnabled(t){return!!N(t)&&V(t,this.verificationEnabled)}enableResultDeduplication(t,e){N(t)&&(e&&this.enableLatestOverlapping(t,!1),c(this,p,"f").set(t,e))}isResultDeduplicationEnabled(t){return!!N(t)&&V(t,this.duplicateFilterEnabled)}setDuplicateForgetTime(t,e){N(t)&&(e>18e4&&(e=18e4),e<0&&(e=0),c(this,h,"f").set(t,e))}getDuplicateForgetTime(t){return N(t)?V(t,this.duplicateForgetTime):-1}setMaxOverlappingFrames(t,e){N(t)&&c(this,m,"f").set(t,e)}getMaxOverlappingFrames(t){return N(t)?V(t,this.maxOverlappingFrames):-1}enableLatestOverlapping(t,e){N(t)&&(e&&this.enableResultDeduplication(t,!1),c(this,f,"f").set(t,e))}isLatestOverlappingEnabled(t){return!!N(t)&&V(t,this.latestOverlappingEnabled)}getFilteredResultItemTypes(){let t=0;const i=[e.EnumCapturedResultItemType.CRIT_BARCODE,e.EnumCapturedResultItemType.CRIT_TEXT_LINE,e.EnumCapturedResultItemType.CRIT_DETECTED_QUAD,e.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE];for(let e=0;e<i.length;e++)(this.verificationEnabled[i[e]]||this.duplicateFilterEnabled[i[e]])&&(t|=i[e]);return t}onOriginalImageResultReceived(t){}latestOverlappingFilter(t){var i,n,s;const o=this.isResultCrossVerificationEnabled(e.EnumCapturedResultItemType.CRIT_BARCODE),a=this.isLatestOverlappingEnabled(e.EnumCapturedResultItemType.CRIT_BARCODE);if(a){const r=5,l=60,c=a?this.getMaxOverlappingFrames(e.EnumCapturedResultItemType.CRIT_BARCODE):5,u=t.items.length,p=null===(s=null===(n=null===(i=null==t?void 0:t.intermediateResult)||void 0===i?void 0:i[0])||void 0===n?void 0:n.intermediateResultUnits)||void 0===s?void 0:s[1].localizedBarcodes,h=p?p.length:0;let f=[];const m=[],d={x:0,y:0};let y=new Array(u).fill(-1),g=0;const I=t.items.map((t=>{if(1!==t.type){const e=(BigInt(t.format)&BigInt(L.BF_ONED))!=BigInt(0)||(BigInt(t.format)&BigInt(L.BF_GS1_DATABAR))!=BigInt(0);return new F(c,e?1:2,e,t)}})).filter(Boolean);if(this.overlapSet.length>0){const t=new Array(u).fill(new Array(this.overlapSet.length).fill(1));let e=0;for(;e<u;){const i={x:0,y:0},n=new Array(u).fill(-1);let s=!1;for(;e<u;e++){if(!I[e])continue;const o=I[e].item;for(let a=0;a<this.overlapSet.length;a++){if(t[e][a]<1)continue;const r=this.overlapSet[a],l=r.item;if(o.format===l.format&&o.text===l.text){if(s=r.isProbablySameLocationWithOffset(I[e],i),s){n[e]=a,t[e][a]=0;break}}else t[e][a]=0}if(s)break}if(s){for(let s=0;s<u;s++){if(s===e||!I[s])continue;const o=I[s].item;for(let e=0;e<this.overlapSet.length;e++){if(t[s][e]<1)continue;if(n.includes(e))continue;const a=this.overlapSet[e],r=a.item;if(o.format===r.format&&o.text===r.text){if(a.isMatchedLocationWithOffset(I[s],i)){n[s]=e,t[s][e]=0;break}}else t[s][e]=0}}const s=n.filter((t=>-1!==t)).length;s>g&&(g=s,y=n,d.x=i.x,d.y=i.y)}}if(0===g){for(let e=0;e<u;e++){const i=I[e].item;for(let n=0;n<this.overlapSet.length;n++){if(t[e][n]<1)continue;if(y.includes(n))continue;const s=this.overlapSet[n],o=s.item;if(i.format===o.format&&i.text===o.text){if(s.isMatchedLocationWithOffset(I[e])){y[e]=n,t[e][n]=0;break}}else t[e][n]=0}}g+=y.filter((t=>-1!=t)).length}let i=this.overlapSet.length<=b?g>=M:g>=O;if(!i&&a&&h>0){let t=0;for(let e=0;e<this.overlapSet.length;e++){const i=this.overlapSet[e];for(let e=0;e<h;e++){if(i.isOverlappedLocationWithOffset(p[e],d)){t++;break}}}i=this.overlapSet.length<=b?t>=_:t>=B}i||(this.overlapSet=[])}if(0===this.overlapSet.length)this.stabilityCount=0,t.items.forEach(((t,e)=>{if(1!==t.type){const i=Object.assign({},t),n=(BigInt(t.format)&BigInt(L.BF_ONED))!=BigInt(0)||(BigInt(t.format)&BigInt(L.BF_GS1_DATABAR))!=BigInt(0),s=t.confidence<l,a=new F(c,n?1:2,n,i);o&&n&&s&&m.push(e),this.overlapSet.push(a)}}));else{let e=!0;a?(Math.abs(d.x)>w||Math.abs(d.y)>w)&&(e=!1):e=!1;for(let i=0;i<t.items.length;i++){const t=y[i];if(t<0&&I[i]){const t=I[i].item;let n={points:[{x:0,y:0},{x:0,y:0},{x:0,y:0},{x:0,y:0}],area:0};for(let i=0;i<4;i++)n.points[i].x=e?t.location.points[i].x-d.x:t.location.points[i].x,n.points[i].y=e?t.location.points[i].y-d.y:t.location.points[i].y;for(let s=0;s<this.overlapSet.length;s++){if(y.includes(s))continue;const o=this.overlapSet[s].item.text,a=this.overlapSet[s].item.format;if(t.format===a&&t.text===o){if(this.overlapSet[s].isOverlappedLocationWithOffset(t,d,!1)){const e=Object.assign({},t),n=(BigInt(e.format)&BigInt(L.BF_ONED))!=BigInt(0)||(BigInt(e.format)&BigInt(L.BF_GS1_DATABAR))!=BigInt(0),o=n?1:2;this.overlapSet[s]=new F(c,o,n,e),y[i]=s;break}if(I[i].isOneD){let o={points:[{x:0,y:0},{x:0,y:0},{x:0,y:0},{x:0,y:0}],area:0};for(let t=0;t<4;t++)o.points[t].x=e?this.overlapSet[s].location.points[t].x:this.overlapSet[s].location.points[t].x+d.x,o.points[t].y=e?this.overlapSet[s].location.points[t].y:this.overlapSet[s].location.points[t].y+d.y;let a={points:[{x:0,y:0},{x:0,y:0},{x:0,y:0},{x:0,y:0}],area:0};if(S(n,o,t.moduleSize,a)){t.location=a;const e=Object.assign({},t),n=(BigInt(e.format)&BigInt(L.BF_ONED))!=BigInt(0)||(BigInt(e.format)&BigInt(L.BF_GS1_DATABAR))!=BigInt(0),o=n?1:2;this.overlapSet[s]=new F(c,o,n,e),y[i]=s;break}}}}}else{if(e){if(I[i]){I[i].item.location=this.overlapSet[t].location}}else{const e=Object.assign({},I[i].item),n=(BigInt(e.format)&BigInt(L.BF_ONED))!=BigInt(0)||(BigInt(e.format)&BigInt(L.BF_GS1_DATABAR))!=BigInt(0),s=n?1:2;this.overlapSet[t]=new F(c,s,n,e)}this.overlapSet[t]&&(this.overlapSet[t].overlapCount=c,this.overlapSet[t].verificationCount=2,this.overlapSet[t].crossVerificationFrame=r)}}e?this.stabilityCount<A&&this.stabilityCount++:this.stabilityCount=0;let i=!0;for(let t=0;t<this.overlapSet.length;t++){if(y.includes(t))continue;const n=this.overlapSet[t];n.overlapCount--,n.crossVerificationFrame--;const s=n.overlapCount+this.stabilityCount;if(a&&s>0){for(let t=0;t<u;t++){if(n.isOverlappedLocationWithOffset(I[t],d,!1)){i=!1;break}}if(!i)break;const t=n.item;if(!e){for(let t=0;t<4;t++)n.location.points[t].x+=d.x,n.location.points[t].y+=d.y;t.location=n.location}2===n.verificationCount&&f.push(t)}}if(a&&!i){f=[];for(let t=0;t<this.overlapSet.length;t++){if(y.includes(t))continue;const e=this.overlapSet[t];e.overlapCount=0-this.stabilityCount,e.crossVerificationFrame=0,e.verificationCount=0}}for(let t=0;t<u;t++){if(-1!==y[t]||!I[t])continue;const i=I[t].item;if(e){for(let e=0;e<4;e++)I[t].location.points[e].x-=d.x,I[t].location.points[e].y-=d.y;i.location=I[t].location}let n=!1;for(let e of this.overlapSet)if(!(e.crossVerificationFrame<=0&&e.verificationCount<=0)&&(n=e.isLocationOverlap(I[t].location,I[t].locationArea),n))break;if(n){m.push(t);continue}const s=Object.assign({},i),a=(BigInt(i.format)&BigInt(L.BF_ONED))!=BigInt(0)||(BigInt(i.format)&BigInt(L.BF_GS1_DATABAR))!=BigInt(0),r=i.confidence<l,u=new F(c,a?1:2,a,s);o&&a&&r?m.push(t):u.verificationCount=2,this.overlapSet.push(u)}this.overlapSet=this.overlapSet.filter((t=>!(t.overlapCount+this.stabilityCount<=0&&t.crossVerificationFrame<=0)))}m.sort(((t,e)=>e-t)).forEach(((e,i)=>{t.items.splice(e,1)})),f.forEach((e=>{t.items.push(Object.assign(Object.assign({},e),{overlapped:!0}))}))}}onDecodedBarcodesReceived(t){this.latestOverlappingFilter(t),W(this,t.items,e.EnumCapturedResultItemType.CRIT_BARCODE)}onRecognizedTextLinesReceived(t){W(this,t.items,e.EnumCapturedResultItemType.CRIT_TEXT_LINE)}onDetectedQuadsReceived(t){W(this,t.items,e.EnumCapturedResultItemType.CRIT_DETECTED_QUAD)}onNormalizedImagesReceived(t){W(this,t.items,e.EnumCapturedResultItemType.CRIT_NORMALIZED_IMAGE)}},t.UtilityModule=class{static getVersion(){return`1.4.32(Worker: ${e.innerVersions.utility&&e.innerVersions.utility.worker||"Not Loaded"}, Wasm: ${e.innerVersions.utility&&e.innerVersions.utility.wasm||"Not Loaded"})`}}}));
