<!DOCTYPE html>
<html lang="pt-br">
<head>
  <meta charset="UTF-8">
  <title>Dynamsoft QR Scanner</title>
  <!-- Bundle completo via CDN com todos os módulos necessários -->
  <script src="https://cdn.jsdelivr.net/npm/dynamsoft-barcode-reader-bundle@10.5.3000/dist/dbr.bundle.js"></script>
</head>
<body>
  <h2>Dynamsoft QR Scanner</h2>
  <div id="scanner" style="width: 500px; height: 300px; border: 1px solid #ccc;"></div>
  <p id="output">Aguardando leitura...</p>

  <script>
    // Configuração do scanner: QR code apenas, modo contínuo até achar único
    const config = {
      license: "DLS2eyJoYW5kc2hha2VDb2RlIjoiMTA0MjM1MDM4LU1UQTBNak0xTURNNExYZGxZaTFVY21saGJGQnliMm8iLCJtYWluU2VydmVyVVJMIjoiaHR0cHM6Ly9tZGxzLmR5bmFtc29mdG9ubGluZS5jb20iLCJvcmdhbml6YXRpb25JRCI6IjEwNDIzNTAzOCIsInN0YW5kYnlTZXJ2ZXJVUkwiOiJodHRwczovL3NkbHMuZHluYW1zb2Z0b25saW5lLmNvbSIsImNoZWNrQ29kZSI6LTYzNzE3MzU1M30=",
      barcodeFormats: [Dynamsoft.DBR.EnumBarcodeFormat.BF_QR_CODE],  // somente QR
      scanMode: Dynamsoft.EnumScanMode.SM_MULTI_UNIQUE,             // contínuo até achar
      container: document.getElementById("scanner"),
      engineResourcePaths: {
        rootDirectory: "https://cdn.jsdelivr.net/npm/dynamsoft-barcode-reader-bundle@10.5.3000/dist"
      },
      onUniqueBarcodeScanned: result => {
        // Usa 'text' ao invés de 'barcodeText' (API V10) para extrair conteúdo ([dynamsoft.com](https://www.dynamsoft.com/barcode-reader/docs/web/programming/javascript/api-reference/interfaces/barcode-result-item.html?utm_source=chatgpt.com))
        document.getElementById("output").innerText = "QR code lido: " + result.text;
        // Para o scanner após a leitura (opcional)
        // scanner.dispose();
      }
    };

    (async () => {
      try {
        const scanner = new Dynamsoft.BarcodeScanner(config);
        await scanner.launch();
      } catch (ex) {
        console.error("Erro ao iniciar scanner:", ex);
        document.getElementById("output").innerText = "Erro: " + ex.message;
      }
    })();
  </script>
</body>
</html>
